# -*- coding: utf-8 -*-

from django.conf import settings


def mask_secret(secret):
    if secret and len(secret) >= 2:
        return '%s***%s' % (secret[0], secret[-1])
    else:
        return secret


def client_to_response(client, full_info=False):
    data = {
        'id': client.id,
        'name': client.name,
        'url': None,
        'parent': None,
        'services': [],
        'attributes': {},
    }
    if client.abc_service_id:
        data['services'].append({
            'abc_service_id': client.abc_service_id,
            'request_id': client.abc_request_id,
        })
    if client.is_secret_saved_to_vault():
        vault_dict = dict(
            secret_uuid=client.vault_secret_uuid,
            version_uuid=client.vault_version_uuid,
        )
        data['attributes'].update(
            vault_link=settings.VAULT_SECRET_LINK_TEMPLATE.format(**vault_dict),
            **vault_dict
        )
    if full_info:
        data['attributes'].update(
            client_secret=mask_secret(client.client_secret),
            old_client_secret=mask_secret(client.old_client_secret),
        )
    return data
