# coding: utf-8

from libcpp cimport bool as bool_t
from libc.stdint cimport uint32_t, uint64_t
from util.generic.string cimport TString, TStringBuf


cdef extern from "passport/backend/oauth/tvm_api/tvm_keygen/utils.h":
    cdef void raise_py_error()


cdef extern from "library/cpp/tvmauth/src/utils.h" namespace "NTvmAuth::NUtils":
    TString Bin2base64url(TStringBuf buf) except +raise_py_error
    TString Base64url2bin(TStringBuf buf) except +raise_py_error


cdef extern from "library/cpp/tvmauth/src/rw/keys.h" namespace "NTvmAuth::NRw":
    cdef cppclass TKeyPair:
        TString Private
        TString Public
    cdef cppclass TRwPublicKey:
        TRwPublicKey(TStringBuf body) except +raise_py_error
        bool_t CheckSign(TStringBuf ticket, TStringBuf sign) except +raise_py_error

    cdef cppclass TRwPrivateKey:
        TRwPrivateKey(TStringBuf body, uint32_t id) except +raise_py_error
        TString SignTicket(TStringBuf ticket) except +raise_py_error

    TKeyPair GenKeyPair(size_t size) except +raise_py_error


cdef extern from "passport/infra/libs/cpp/tvm/common/decryptor.h" namespace "NPassport::NTvmCommon":
    cdef cppclass TDecryptor:
        TDecryptor(const TString& aesKey) except +raise_py_error
        TString DecryptAes(const TString& str, const char* detail, uint64_t id) except +raise_py_error


def generate_rw_keys(int key_size=2048):
    cdef TKeyPair pair
    pair = GenKeyPair(key_size)
    return Bin2base64url(pair.Public).decode(), Bin2base64url(pair.Private).decode()


def parse_key(public, private):
    cdef TString someData
    cdef TString decodedPublic
    cdef TString decodedPrivate
    cdef TRwPublicKey* publicKey
    cdef TRwPrivateKey* privateKey

    publicKey = NULL
    privateKey = NULL

    decodedPublic = Base64url2bin(<TString>public.encode())
    assert decodedPublic.size() > 0, "bad base64 in public key"

    decodedPrivate = Base64url2bin(<TString>private.encode())
    assert decodedPrivate.size() > 0, "bad base64 in private key"

    someData = "some_data"

    try:
        publicKey = new TRwPublicKey(<TStringBuf>decodedPublic)
        privateKey = new TRwPrivateKey(<TStringBuf>decodedPrivate, 0)
        res = publicKey.CheckSign(someData, privateKey.SignTicket(someData))
        assert res, "public and private keys are mismatched"
    finally:
        if publicKey != NULL:
            del publicKey
        if privateKey != NULL:
            del privateKey

def decrypt(aes_key, data, int id):
    cdef TDecryptor* decryptor
    decryptor = NULL

    try:
        decryptor = new TDecryptor(<TString>aes_key)
        return decryptor.DecryptAes(<TString>data, "", id).decode()
    finally:
        if decryptor != NULL:
            del decryptor
