# -*- coding: utf-8 -*-
from passport.backend.passport_nginx_config.configs.base import BaseGuardConfig


class GuardOauth(BaseGuardConfig):
    _cert_names = {
        'intranet': {
            'testing': 'passport-test.yandex-team.ru',
            'rc': 'guard.oauth-rc.yandex-team.ru',
            'production': 'passport.yandex-team.ru',
        },
        'localhost': {
            'testing': 'guard.oauth-test',
            'rc': 'guard.oauth-rc',
            'production': 'guard.oauth',
        },
        'stress': {
            'stress': 'guard.oauth-load',
        },
    }
    _server_name_prefixes = {
        'intranet': {
            'testing': 'guard.oauth-test.yandex-team',
            'rc': 'guard.oauth-rc.yandex-team',
            'production': 'guard.oauth.yandex-team',
        },
        'localhost': {
            'testing': 'guard.oauth-test.yandex',
            'rc': 'guard.oauth-rc.yandex',
            'production': 'guard.oauth.yandex',
        },
        'stress': {
            'stress': 'guard.oauth-load.yandex',
        },
    }


class GuardYasmsAdmin(BaseGuardConfig):
    _cert_names = {
        'intranet': {
            'testing': None,
            'rc': None,
            'production': 'guard.yasms.yandex-team.ru',
        },
        'localhost': {
            'testing': None,
            'rc': None,
            'production': None,
        },
        'stress': {
            'stress': None,
        },
    }
    _server_name_prefixes = {
        'intranet': {
            'testing': None,
            'rc': None,
            'production': ['guard.yasms.yandex-team', 'guard.yasms-test.yandex-team'],
        },
        'localhost': {
            'testing': None,
            'rc': None,
            'production': None,
        },
        'stress': {
            'stress': None,
        },
    }


class GuardMail(BaseGuardConfig):
    _cert_names = {
        'intranet': {
            'testing': None,
            'rc': None,
            'production': 'guard.mail.yandex-team.ru',
        },
        'localhost': {
            'testing': None,
            'rc': None,
            'production': None,
        },
        'stress': {
            'stress': None,
        },
    }
    _server_name_prefixes = {
        'intranet': {
            'testing': None,
            'rc': None,
            'production': 'guard.mail.yandex-team',
        },
        'localhost': {
            'testing': None,
            'rc': None,
            'production': None,
        },
        'stress': {
            'stress': None,
        },
    }


class GuardSts(BaseGuardConfig):
    _cert_names = {
        'intranet': {
            'testing': None,
            'rc': None,
            'production': 'guard.sts.yandex-team.ru',
        },
        'localhost': {
            'testing': None,
            'rc': None,
            'production': None,
        },
        'stress': {
            'stress': None,
        },
    }
    _server_name_prefixes = {
        'intranet': {
            'testing': None,
            'rc': None,
            'production': 'guard.sts.yandex-team',
        },
        'localhost': {
            'testing': None,
            'rc': None,
            'production': None,
        },
        'stress': {
            'stress': None,
        },
    }


class GuardIntranetServices(BaseGuardConfig):
    _cert_names = {
        'intranet': {
            'testing': None,
            'rc': None,
            'production': 'guard.yandex-team.ru',
        },
        'localhost': {
            'testing': None,
            'rc': None,
            'production': None,
        },
        'stress': {
            'stress': None,
        },
    }
    _server_name_prefixes = {
        'intranet': {
            'testing': None,
            'rc': None,
            'production': [
                'guard.%s.yandex-team' % subdomain
                for subdomain in (
                    'a',
                    'abc',
                    'bot',
                    'crm.hd',
                    'crt-api',
                    'crt',
                    'deploy',
                    'eds',
                    'help',
                    'idm',
                    'juggler',
                    'kolhoz',
                    'nanny',
                    'newci',
                    'nirvana',
                    'ok',
                    'puncher',
                    'q',
                    'review',
                    'sandbox',
                    'skotty.sec',
                    'st',
                    'staff',
                    'wiki',
                    'yav',
                    'yql',
                    'yt',
                )
            ],
        },
        'localhost': {
            'testing': None,
            'rc': None,
            'production': None,
        },
        'stress': {
            'stress': None,
        },
    }
