from passport.backend.passport_nginx_config.configs.base import (
    BasePassportExternalConfig,
    BasePassportInternalConfig,
    PASSPORT_RU_TLDS,
    PASSPORT_TLDS,
)


PASSPORT_SUPPORT_CHAT_ALIASES = {
    'testing': {
        'music': 'b39e4b08-1d1b-9419-6c13-5cfbf315de98',
    },
    'production': {
        'afisha': '23fe7556-efee-420c-8b76-55dfb2733225',
        'business': '5cb78286-a944-4c0f-bf33-b5c282eae053',
        'direct': '840c4ce4-ed25-4c66-a7c7-ba8c001e02d9',
        'disk': '45d1ee03-5306-98da-4e0e-276737c17d34',
        'id': 'e0271d00-30f7-9cf7-4c16-c3f95d5b10cd',
        'invest': '1e560e75-4d04-4fd1-ae38-670a778fda79',
        'kinopoisk': '9394b605-89aa-957e-5cd1-5fc7d79a9034',
        'main': '0b66fc05-62f8-9d2b-46f4-9b4cb742a1ab',
        'messenger': '5d8e56bb-08ab-4fe8-ac54-7d9e7d4f6b5c',
        'music': 'ee219503-b69b-9484-405b-6877a510e13c',
        'o': '2d001e07-0165-9004-5972-3c2857a2ac80',
        'plus': '80027008-e39a-986b-5f64-822d65ab117c',
        'q': 'efcf11b5-ffc2-4ff6-ae6d-79190d7c5419',
        'station': 'bde37cf3-eb59-4f93-8e5b-1809858a9ac1',
        'surveys': '41c58a75-35e3-4f16-82ea-3420759a8af0',
        'tv': '2dfbe86d-09dc-4441-a68b-6e591a7abda6',
        'uslugi': '3ea8c303-761b-9ce6-7a27-1a6cafa572f2',
        'zapravki': '3d8f0007-f610-914e-45f7-3eddaf3cc441',
    },
}
PASSPORT_SUPPORT_CHAT_ALIASES['rc'] = PASSPORT_SUPPORT_CHAT_ALIASES['production']


class PassportWeb(BasePassportExternalConfig):
    _cert_names = {
        'intranet': {
            'development': None,
            'testing': 'passport-test.yandex-team.ru',
            'rc': 'passport-rc.yandex-team.ru',
            'production': 'passport.yandex-team.ru',
        },
        'localhost': {
            'development': 'passportdev',
            'testing': 'passport-test.yandex.ru',
            'rc': 'passport-rc.yandex.ru',
            'production': 'passport.yandex.ru',
        },
        'stress': {
            'stress': 'passport-load.yandex.ru',
        },
    }
    _server_name_prefixes = {
        'intranet': {
            'development': None,
            'testing': 'passport-test.yandex-team',
            'rc': 'passport-rc.yandex-team',
            'production': 'passport.yandex-team',
        },
        'localhost': {
            'development': '0.passportdev.yandex',
            'testing': 'passport-test.yandex',
            'rc': 'passport-rc.yandex',
            'production': 'passport.yandex',
        },
        'stress': {
            'stress': 'passport-load.yandex',
        },
    }
    _tlds = {
        'intranet': {
            'development': None,
            'testing': ['ru'],
            'rc': ['ru'],
            'production': ['ru'],
        },
        'localhost': {
            'development': ['ru'],
            'testing': PASSPORT_TLDS,
            'rc': PASSPORT_TLDS,
            'production': PASSPORT_TLDS,
        },
        'stress': {
            'stress': ['ru'],
        },
    }

    _order_history_hosts = {
        'localhost': {
            'development': 'test.ohio-www.yandex.ru',
            'testing': 'test.ohio-www.yandex.ru',
            'rc': 'rc.ohio-www.yandex.ru',
            'production': 'prod.ohio-www.yandex.ru',
        },
    }

    def _get_keepalive_timeout(self):
        # В ятиме величина меньше из-за переходов между публичными и внутренними сетями
        return 5 if self.yenv_name == 'intranet' else 120

    def _get_preload_hsts(self):
        return self.yenv_name == 'localhost' and self.yenv_type == 'production'

    def _get_order_history_host(self):
        return self._order_history_hosts.get(self.yenv_name, {}).get(self.yenv_type)

    def _get_use_antirobot(self):
        return True

    def _get_support_chat_aliases(self):
        if self.yenv_name != 'localhost':
            return {}
        return PASSPORT_SUPPORT_CHAT_ALIASES.get(self.yenv_type, {})

    def _get_redirect_from_ua(self):
        return self.yenv_name == 'localhost'

    def _get_serve_lk_pages(self):
        return self.yenv_name != 'intranet'

    def _get_serve_saml_sso_metadata_url(self):
        return self.yenv_name == 'localhost'

    def get_custom_settings(self):
        settings = super(PassportWeb, self).get_custom_settings()
        settings.update(
            define_upstreams=True,
            default_host='%s.ru' % self._get_passport_host_prefix(),
            keepalive_timeout=self._get_keepalive_timeout(),
            preload_hsts=self._get_preload_hsts(),
            order_history_host=self._get_order_history_host(),
            use_antirobot=self._get_use_antirobot(),
            support_chat_aliases=self._get_support_chat_aliases(),
            redirect_from_ua=self._get_redirect_from_ua(),
            serve_lk_pages=self._get_serve_lk_pages(),
            serve_saml_sso_metadata_url=self._get_serve_saml_sso_metadata_url(),
        )
        return settings


class BaseForeignPassportWeb(PassportWeb):
    """
    Базовый класс для конфигов "зарубежного паспорта": паспортного фронта на неяндексовом домене и
    с урезанной функциональностью
    """
    template_name = 'passport_web'

    _server_name_prefixes = {}
    _tlds = {}

    def get_custom_settings(self):
        settings = super(BaseForeignPassportWeb, self).get_custom_settings()
        settings.update(
            define_upstreams=False,  # уже объявлены в конфиге PassportWeb
            default_host=None,
            order_history_host=None,
            support_chat_aliases={},
            redirect_from_ua=False,
            serve_lk_pages=False,
        )
        return settings


class PassportWebToloka(BaseForeignPassportWeb):
    _cert_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': 'passport-test.toloka-test.ai',
            'rc': None,
            'production': 'passport.toloka.ai',
        },
        'stress': {
            'stress': None,
        },
    }
    _server_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': ['passport-test.toloka-test.ai'],
            'rc': None,
            'production': ['passport.toloka.ai'],
        },
        'stress': {
            'stress': None,
        },
    }


class PassportWebPracticum(BaseForeignPassportWeb):
    _cert_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': 'passport.practicum.com',
        },
        'stress': {
            'stress': None,
        },
    }
    _server_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': ['passport.practicum.com'],
        },
        'stress': {
            'stress': None,
        },
    }


class PassportWebYangoDelivery(BaseForeignPassportWeb):
    _cert_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': 'passport-test.yango.delivery',
            'rc': None,
            'production': 'passport.yango.delivery',
        },
        'stress': {
            'stress': None,
        },
    }
    _server_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': ['passport-test.yango.delivery'],
            'rc': None,
            'production': ['passport.yango.delivery'],
        },
        'stress': {
            'stress': None,
        },
    }


class PassportWebYangoCom(BaseForeignPassportWeb):
    _cert_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': 'passport-test.yango.com',
            'rc': None,
            'production': 'passport.yango.com',
        },
        'stress': {
            'stress': None,
        },
    }
    _server_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': ['passport-test.yango.com'],
            'rc': None,
            'production': ['passport.yango.com'],
        },
        'stress': {
            'stress': None,
        },
    }


class PassportApi(BasePassportInternalConfig):
    _cert_names = {
        'intranet': {
            'development': None,
            'testing': 'passport-test-internal.yandex-team.ru',
            'rc': 'passport-rc-internal.yandex-team.ru',
            'production': 'passport-internal.yandex-team.ru',
        },
        'localhost': {
            'development': 'passportdev',
            'testing': 'passport-test-internal.yandex.ru',
            'rc': 'passport-rc-internal.yandex.ru',
            'production': 'passport-internal.yandex.ru',
        },
        'stress': {
            'stress': 'passport-load-internal.yandex.ru',
        },
    }
    _server_names = {
        'intranet': {
            'development': None,
            'testing': ['passport-test-internal.yandex-team.ru'],
            'rc': ['passport-rc-internal.yandex-team.ru'],
            'production': ['passport-internal.yandex-team.ru'],
        },
        'localhost': {
            'development': ['0-internal.passportdev.yandex.ru'],
            'testing': ['passport-test-internal.yandex.ru'],
            'rc': ['passport-rc-internal.yandex.ru'],
            'production': ['passport-internal.yandex.ru'],
        },
        'stress': {
            'stress': ['passport-load-internal.yandex.ru'],
        },
    }

    @property
    def is_applicable(self):
        return not self.is_plus_instance and super(PassportApi, self).is_applicable


class PassportPlusApi(BasePassportInternalConfig):
    template_name = 'passport_api'

    _cert_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': 'plus-internal.passport.yandex.net',
        },
        'stress': {
            'stress': None,
        },
    }
    _server_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': ['plus-internal.passport.yandex.net'],
        },
        'stress': {
            'stress': None,
        },
    }

    def _get_slb_ips(self):
        return ['2a02:6b8:0:3400:0:e:0:3']

    @property
    def is_applicable(self):
        return self.is_plus_instance and super(PassportPlusApi, self).is_applicable


class PassportPrestableApi(PassportApi):
    template_name = 'passport_api'

    _slb_ips = {
        'intranet': {
            'development': (),
            'testing': (),
            'rc': (),
            'production': (
                '2a02:6b8::3400:0:e:0:12',
            ),
        },
        'localhost': {
            'development': (),
            'testing': (),
            'rc': (),
            'production': (
                '2a02:6b8::3400:0:e:0:11',
            ),
        },
        'stress': {
            'stress': (),
        },
    }
    _cert_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': 'passport-prestable-internal.yandex-team.ru',
        },
        'localhost': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': 'passport-prestable-internal.yandex.ru',
        },
        'stress': {
            'stress': None,
        },
    }
    _server_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': ['passport-prestable-internal.yandex-team.ru'],
        },
        'localhost': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': ['passport-prestable-internal.yandex.ru'],
        },
        'stress': {
            'stress': None,
        },
    }

    @property
    def is_applicable(self):
        return super(PassportPrestableApi, self).is_applicable and (
            self.fqdn.startswith('passport-m') or self.fqdn.startswith('passport-yateam-m')
        )

    def get_custom_settings(self):
        settings = super(PassportPrestableApi, self).get_custom_settings()
        settings.update(
            skip_default_section=True,
        )
        return settings


class PassportMagic(BasePassportExternalConfig):
    _cert_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': 'magic.passport-test.yandex.ru',
            'rc': 'magic.passport-rc.yandex.ru',
            'production': 'magic.passport.yandex.ru',
        },
        'stress': {
            'stress': None,
        },
    }
    _server_name_prefixes = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': 'magic.passport-test.yandex',
            'rc': 'magic.passport-rc.yandex',
            'production': 'magic.passport.yandex',
        },
        'stress': {
            'stress': None,
        },
    }
    _tlds = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': PASSPORT_TLDS,
            'rc': PASSPORT_TLDS,
            'production': PASSPORT_TLDS,
        },
        'stress': {
            'stress': None,
        },
    }


class EmailValidatorApi(BasePassportInternalConfig):
    _server_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': ['validator-test.yandex.net'],
            'rc': ['validator-rc.yandex.net'],
            'production': ['validator.yandex.net'],
        },
        'stress': {
            'stress': None,
        },
    }


class Autofill(BasePassportExternalConfig):
    _cert_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': 'autofill-test.yandex.ru',
            'rc': 'autofill-rc.yandex.ru',
            'production': 'autofill.yandex.ru',
        },
        'stress': {
            'stress': None,
        },
    }
    _server_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': None,
        },
        'localhost': {
            'development': None,
            'testing': ['autofill-test.yandex.ru'],
            'rc': ['autofill-rc.yandex.ru'],
            'production': ['autofill.yandex.ru'],
        },
        'stress': {
            'stress': None,
        },
    }


class Id(PassportWeb):
    _cert_names = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': 'id.yandex-team.ru',
        },
        'localhost': {
            'development': None,
            'testing': 'id-test.yandex.ru',
            'rc': 'id-rc.yandex.ru',
            'production': 'id.yandex.ru',
        },
        'stress': {
            'stress': None,
        },
    }
    _server_name_prefixes = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': 'id.yandex-team',
        },
        'localhost': {
            'development': None,
            'testing': 'id-test.yandex',
            'rc': 'id-rc.yandex',
            'production': 'id.yandex',
        },
        'stress': {
            'stress': None,
        },
    }
    _tlds = {
        'intranet': {
            'development': None,
            'testing': None,
            'rc': None,
            'production': ['ru'],
        },
        'localhost': {
            'development': None,
            'testing': PASSPORT_TLDS,
            'rc': ['ru'],
            'production': PASSPORT_TLDS,
        },
        'stress': {
            'stress': None,
        },
    }

    def get_custom_settings(self):
        settings = super(Id, self).get_custom_settings()
        settings.update(
            landing_page_constructor_host='lpc-internal.yandex.net',
            use_ru_landing_page_for_tlds=PASSPORT_RU_TLDS,
        )
        return settings
