from passport.backend.passport_nginx_config.configs.base import (
    BasePassportExternalConfig,
    BaseSsoConfig,
    PASSPORT_TLDS,
)


class SsoPassport(BaseSsoConfig):
    _cert_names = {
        'localhost': {
            'testing': 'sso.passport-test.yandex.ru',
            'production': 'sso.passport.yandex.ru',
        },
    }
    _server_name_prefixes = {
        'localhost': {
            'testing': 'sso.passport-test.yandex',
            'production': 'sso.passport.yandex',
        },
    }
    _tlds = {
        'localhost': {
            'testing': PASSPORT_TLDS,
            'production': PASSPORT_TLDS,
        },
    }


class SsoKinopoisk(BaseSsoConfig):
    _cert_names = {
        'localhost': {
            'testing': 'sso.testing.kinopoisk.ru',
            'production': 'sso.kinopoisk.ru',
        },
    }
    _server_names = {
        'localhost': {
            'testing': ['sso.testing.kinopoisk.ru'],
            'production': ['sso.kinopoisk.ru'],
        },
    }


class SsoEdadeal(BaseSsoConfig):
    _cert_names = {
        'localhost': {
            'testing': None,
            'production': 'sso.edadeal.ru',
        },
    }
    _server_names = {
        'localhost': {
            'testing': None,
            'production': ['sso.edadeal.ru'],
        },
    }


class SsoEdastage(BaseSsoConfig):
    """Тестовый домен для Едадила, в продакшн-окружении"""
    _cert_names = {
        'localhost': {
            'testing': None,
            'production': 'sso.edastage.ru',
        },
    }
    _server_names = {
        'localhost': {
            'testing': None,
            'production': ['sso.edastage.ru'],
        },
    }


class SsoYandexsport(BaseSsoConfig):
    _cert_names = {
        'localhost': {
            'testing': 'sso.testing.yandexsport.ru',
            'production': 'sso.yandexsport.ru',
        },
    }
    _server_names = {
        'localhost': {
            'testing': ['sso.testing.yandexsport.ru'],
            'production': ['sso.yandexsport.ru'],
        },
    }


class SsoK50(BaseSsoConfig):
    _cert_names = {
        'localhost': {
            'testing': 'sso.k50dev.ru',
            'production': 'sso.k50.ru',
        },
    }
    _server_names = {
        'localhost': {
            'testing': ['sso.k50dev.ru', 'sso.k50wldev.ru'],
            'production': ['sso.k50.ru'],
        },
    }


class SsoToloka(BaseSsoConfig):
    _cert_names = {
        'localhost': {
            'testing': 'sso.test.toloka.ai',
            'production': 'sso.toloka.ai',
        },
    }
    _server_names = {
        'localhost': {
            'testing': ['sso.test.toloka.ai'],
            'production': ['sso.toloka.ai'],
        },
    }


class SsoYango(BaseSsoConfig):
    _cert_names = {
        'localhost': {
            'testing': 'sso.tst.yango.com',
            'production': 'sso.yango.com',
        },
    }
    _server_names = {
        'localhost': {
            'testing': ['sso.tst.yango.com'],
            'production': ['sso.yango.com'],
        },
    }


class SsoAutoRu(BaseSsoConfig):
    _cert_names = {
        'localhost': {
            'production': 'sso.auto.ru',
        },
    }
    _server_names = {
        'localhost': {
            'production': ['sso.auto.ru'],
        },
    }


class SsoAvtoRuTest(BaseSsoConfig):
    """Работают с mimino, этому в продакшн-окружении"""
    _cert_names = {
        'localhost': {
            'production': 'sso.test.avto.ru',
        },
    }
    _server_names = {
        'localhost': {
            'production': ['sso.test.avto.ru'],
        },
    }


class SsoAvtoRuDev(BaseSsoConfig):
    """Работают с mimino, этому в продакшн-окружении"""
    _cert_names = {
        'localhost': {
            'production': 'sso.dev.avto.ru',
        },
    }
    _server_names = {
        'localhost': {
            'production': ['sso.dev.avto.ru'],
        },
    }


class SsoDzen(BaseSsoConfig):
    _cert_names = {
        'localhost': {
            'production': 'sso.dzen.ru',
        },
    }
    _server_names = {
        'localhost': {
            'production': ['sso.dzen.ru'],
        },
    }


class SsoYaRu(BaseSsoConfig):
    _cert_names = {
        'localhost': {
            'testing': 'sso.test.ya.ru',
            'production': 'sso.ya.ru',
        },
    }
    _server_names = {
        'localhost': {
            'testing': ['sso.test.ya.ru'],
            'production': ['sso.ya.ru'],
        },
    }


class TestSso(BasePassportExternalConfig):
    """Фейковый хост для тестирования интеграции MDA 2.0 в сторонние сервисы. Нужен только в тестинге"""
    _cert_names = {
        'localhost': {
            'testing': 'sso-test.kinopoisk.ru',
            'production': None,
        },
    }
    _server_names = {
        'localhost': {
            'testing': ['test.sso-test.kinopoisk.ru'],
            'production': None,
        },
    }
