PY3_LIBRARY()

NEED_REVIEW()

NO_BUILD_IF(OS_WINDOWS)

OWNER(
    g:passport_python
    eugene311
)

PEERDIR(
    library/python/yenv

    passport/backend/library/nginx_config_generator
)

PY_SRCS(
    __init__.py
    build_configs.py
    configs/__init__.py
    configs/base.py
    configs/guard_configs.py
    configs/passport_configs.py
    configs/sso_configs.py
    delete_configs.py
)

RESOURCE(
    templates/autofill.j2                templates/autofill.j2
    templates/base_guard.j2              templates/base_guard.j2
    templates/base_sso.j2                templates/base_sso.j2
    templates/custom_macros.j2           templates/custom_macros.j2
    templates/email_validator_api.j2     templates/email_validator_api.j2
    templates/id.j2                      templates/id.j2
    templates/passport_api.j2            templates/passport_api.j2
    templates/passport_magic.j2          templates/passport_magic.j2
    templates/passport_web.j2            templates/passport_web.j2
    templates/test_sso.j2                templates/test_sso.j2
)

END()

RECURSE(
    cli
)

RECURSE_FOR_TESTS(
    tests
)
