# -*- coding: utf-8 -*-
from logging.config import dictConfig

from flask import Flask
from passport.backend.core.conf import settings
from passport.backend.perimeter import settings as perimeter_settings
from passport.backend.perimeter.auth_api import views
from passport.backend.perimeter.auth_api.auth_logic.logic import get_auth_logic
from passport.backend.perimeter.auth_api.logging_utils.request_id import store_request_id


def create_app():
    app = Flask(__name__)
    app.add_url_rule('/auth', view_func=views.auth, methods=['POST'])
    app.add_url_rule('/status', view_func=views.status, methods=['GET'])
    app.add_url_rule('/ping', view_func=views.ping, methods=['GET'])
    app.add_url_rule('/ping_ldap', view_func=views.ping_ldap, methods=['GET'])

    app.before_first_request(get_auth_logic)  # подгружаем все используемые чекеры
    app.before_request(store_request_id)  # сохраняем id текущего запроса

    return app


def execute_app():
    if not settings.configured:
        settings.configure(perimeter_settings)
    dictConfig(settings.LOGGING)

    application = create_app()
    application.config['LOGGER_NAME'] = settings.APP_LOGGER_NAME

    return application
