# -*- coding: utf-8 -*-


class CheckStatus(object):
    def __init__(self, is_ok, description=None, require_second_steps=None, require_password_change=False,
                 got_errors=False, extra_data=None):
        self.is_ok = is_ok
        self.description = description
        self.require_second_steps = set(require_second_steps or [])
        self.require_password_change = require_password_change
        self.got_errors = got_errors
        self.extra_data = extra_data or {}

    def __repr__(self):
        return '<%s %s>' % (
            self.__class__.__name__,
            ', '.join('%s=%r' % (key, value) for key, value in self.__dict__.items()),
        )


class BaseChecker(object):
    @property
    def is_enabled(self):
        """
        Доступен ли этот метод проверки пароля.
        Может перегружаться в потомках, чтобы уметь отключать определённые чекеры.
        """
        return True  # pragma: no cover

    @property
    def alias(self):
        """Короткое имя чекера (для записи в логи)"""
        return self.__class__.__name__.replace('Checker', '')

    def check(self, login, password, **kwargs):
        """Проверка пары "логин-пароль". Перегружается в потомках, возвращает ответ типа CheckStatus"""
        raise NotImplementedError()  # pragma: no cover
