# -*- coding: utf-8 -*-
from flask import request
from passport.backend.core.logging_utils.formatters import ExceptionFormatter as BaseExceptionFormatter
from passport.backend.perimeter.auth_api.logging_utils.helpers import mask_sensitive_fields


class ExceptionFormatter(BaseExceptionFormatter):
    def make_full_request_info(self, record):
        lines = ['Request: %s' % str(request)]
        if record.request_id:
            lines.append('Request id: %s' % record.request_id)
        lines.append('Request data: %s' % mask_sensitive_fields(request.values.to_dict()))
        return lines
