# -*- coding: utf-8 -*-
from passport.backend.core.conf import settings
from passport.backend.perimeter.auth_api.utils.hash import hash_string


MAX_MASK_LENGTH = 32


def mask_sensitive_fields(data, fields=('password',)):
    data = data.copy()
    for key in data:
        if key in fields:
            data[key] = '***' + hash_string(data[key], salt=settings.PASSWORD_HASH_SALT)[-MAX_MASK_LENGTH:]
    return data
