# -*- coding: utf-8 -*-
import binascii
import os

from flask import request


_REQUEST_ID = None


def get_request_id():
    return _REQUEST_ID


def store_request_id():
    global _REQUEST_ID
    # Если request_id не передали снаружи - сгенерируем свой (более короткий, чтобы различать)
    _REQUEST_ID = request.environ.get('HTTP_X_REQUEST_ID') or binascii.hexlify(os.urandom(8)).decode()
