# -*-  coding: utf-8 -*-
from passport.backend.library.configurator import Configurator
from passport.backend.library.wsgi_runner import Runner
from passport.backend.perimeter.auth_api.app import execute_app
from passport.backend.perimeter.settings.helpers import DEBUG
from passport.backend.utils.warnings import enable_strict_bytes_mode


def _run_app(gunicorn_config_path):
    enable_strict_bytes_mode()

    app = execute_app()

    gunicorn_configs = [gunicorn_config_path]
    if DEBUG:
        gunicorn_configs.append('debug.yaml')

    runner = Runner(
        app,
        config=Configurator('perimeter-auth-api', configs=gunicorn_configs, encoding='utf-8')
    )
    runner.run()


def run_app():
    _run_app('gunicorn.yaml')


def run_app_long():
    _run_app('gunicorn-long.yaml')
