# -*- coding: utf-8 -*-
import base64
import hashlib
import os

from passport.backend.utils.string import smart_bytes


def generate_salt():
    return base64.b64encode(os.urandom(6), altchars=b'./').decode()


def hash_string(string, salt=None):
    salt = salt or generate_salt()
    version = 1
    magic = '$'

    return magic.join([
        str(version),
        salt,
        hashlib.sha256(smart_bytes(string + magic + salt)).hexdigest(),
    ])


def check_hashed_string(string, hashed_string):
    """Проверяет, совпадает ли переданная строка с хешем"""
    if not hashed_string:
        return False
    method, salt, _ = hashed_string.split('$')
    if method == '1':
        return hash_string(string, salt) == hashed_string
    else:
        raise ValueError('Unknown hash type')


def truncated_hash(string):
    """Генерит половину несолёного хэша (для записи в логи)"""
    string = smart_bytes(string)
    return hashlib.sha256(string).hexdigest()[:33]  # как и в ЧЯ
