# -*- coding: utf-8 -*-
import json

from flask import (
    request,
    Response,
)
from passport.backend.perimeter.auth_api.common.exceptions import ValidationError
from passport.backend.utils.string import smart_text


def json_response(*args, **kwargs):
    return Response(
        json.dumps(dict(*args, **kwargs)),
        status=200,
        mimetype='application/json',
    )


def get_request_values():
    if request.method in ['POST', 'PUT']:
        return request.form.to_dict()
    else:
        return request.args.to_dict()


def validate_form(form_values, required_args):
    validated = {}
    for arg_name in (required_args or []):
        if arg_name not in form_values:
            raise ValidationError('`%s` is missing' % arg_name)
        validated[arg_name] = smart_text(form_values[arg_name])
    return validated
