# -*- coding: utf-8 -*-
import logging

from flask import Response
from passport.backend.core.conf import settings
from passport.backend.perimeter.auth_api.ldap.checker import get_ldap_checker


log = logging.getLogger('perimeter.ping')


def ping_ldap():
    ldap_checker = get_ldap_checker()
    # Дёргаем случайный ldap-сервер, чтобы обновить времена ответа. Сам ответ игнорируем.
    ldap_checker.check(
        login=settings.LDAP_TEST_LOGIN,
        password=settings.LDAP_TEST_PASSWORD,
        use_best_server=False,
        log_prefix='[ping] ',
    )

    return Response('ok')
