# -*- coding: utf-8 -*-
import logging

from passport.backend.perimeter.auth_api.ldap.balancer import get_ldap_balancer
from passport.backend.perimeter.auth_api.views.base import json_response


log = logging.getLogger('views.status')


def status():
    response_values = {
        'ldap_timings': get_ldap_balancer().get_timings(),
    }
    log.info('Status report: %s', response_values)
    return json_response(status='ok', **response_values)
