#!/usr/bin/env python
# -*- coding: utf-8 -*-
import argparse
import hashlib
import json
import sys

from passport.backend.perimeter.auth_api.utils.hash import truncated_hash
from passport.backend.utils.warnings import enable_strict_bytes_mode


def run_diag(diag_data, secret, pin):
    diag_data = json.loads(diag_data)
    # проверяем секрет
    if truncated_hash(secret) == diag_data['secret_hash']:
        print('secret: OK')
    else:
        print('secret: ERROR')
    # проверяем пин
    if truncated_hash(secret + str(pin)) == diag_data['secret_pin_hash']:
        print('secret+pin: OK')
    else:
        print('secret+pin: ERROR')
    # проверяем одноразовый пароль
    ts = diag_data['ts']
    step = 10
    for t in range(ts - 7 * 3600 * 24, ts + 7 * 3600 * 24, 10):
        hasher = hashlib.md5()
        hasher.update(b'%d%s%s' % (int(t / step), secret.encode(), str(pin).encode()))
        password = hasher.hexdigest()[0:6]

        if truncated_hash(password) == diag_data['otp_hash']:
            print('otp: OK (ts=%s, offset=%s)' % (t, ts - t))
            return

    print('otp: ERROR')


def main():
    enable_strict_bytes_mode()

    parser = argparse.ArgumentParser(description='Process some integers.')
    parser.add_argument('--diag_data', help='JSON blob from debug.log')
    parser.add_argument('--secret', help='MOTP secret from DB')
    parser.add_argument('--pin', help='MOTP pin from DB')
    args = parser.parse_args()
    if not (args.diag_data and args.secret and args.pin):
        parser.print_usage()
        sys.exit(1)

    run_diag(
        diag_data=args.diag_data,
        secret=args.secret,
        pin=args.pin,
    )


if __name__ == '__main__':
    main()
