# -*- coding: utf-8 -*-
from passport.backend.perimeter.settings import secrets
from passport.backend.perimeter.settings.helpers import IS_UNDER_TESTS
import yenv


if yenv.type == 'production':
    LDAP_SERVERS = [
        'addc.yandex-team.ru',
    ]
    LDAP_USER_DOMAIN = 'ld.yandex.ru'
else:
    LDAP_SERVERS = [
        'test-staff-dc.yandex-team.ru',
    ]
    LDAP_USER_DOMAIN = 'tst.virtual'
LDAP_SERVER_MONITORING_INTERVAL = 60
LDAP_SERVER_MONITORING_SERIE_SIZE = 1000
LDAP_CA_CERT_FILE = '/usr/local/share/ca-certificates/Yandex/Yandex_Internal_CA.crt'
LDAP_SCHEME = 'ldap'
LDAP_PORT = 389
LDAP_START_TLS = True
LDAP_NETWORK_TIMEOUT = 1
LDAP_TIMEOUT = 1
LDAP_TEST_LOGIN = secrets.LDAP_TEST_LOGIN
LDAP_TEST_PASSWORD = secrets.LDAP_TEST_PASSWORD
LDAP_FAILURE_RESPONSE_TIME_MULTIPLIER = 2  # умножается на общий таймаут запроса. Должен быть > 1

# Учитывать ли требование смены пароля, приходящее от AD
ALLOW_PASSWORD_CHANGE = True

REDIS_ENABLED = True
REDIS_HOST = 'localhost'
REDIS_PORT = 6379
REDIS_PASSWORD = secrets.REDIS_PASSWORD
REDIS_EXPIRE_TIME = 30
REDIS_TIMEOUT = 0.5
REDIS_CONNECT_TIMEOUT = 0.5

DB_ENABLED = True
if IS_UNDER_TESTS:
    DB_HOST = DB_DATABASE = None
elif yenv.type == 'production':
    DB_HOST = 'yateam-dbs.passport.yandex.net'
    DB_DATABASE = 'yarad'
elif yenv.type == 'testing':
    DB_HOST = 'cnt-dbs-test.passport.yandex.net'
    DB_DATABASE = 'yarad_yateam'
else:
    DB_HOST = 'localhost'
    DB_DATABASE = 'yarad'
DB_PORT = 3306
DB_USER = secrets.DB_USER
DB_PASSWORD = secrets.DB_PASSWORD
DB_DRIVER = 'mysql'
DB_RETRIES = 2
DB_CONNECT_ARGS = {
    'charset': 'utf8',
    'connect_timeout': 1,
}

if yenv.type == 'production':
    BLACKBOX_URL = 'https://blackbox.yandex-team.ru/'
else:
    BLACKBOX_URL = 'https://blackbox-test.yandex-team.ru/'
BLACKBOX_TIMEOUT = 0.5
BLACKBOX_RETRIES = 2

TVM_KEYRING_CONFIG_NAME = 'perimeter'

PING_TEST_FILE = '/usr/lib/yandex/perimeter/ping.html'

PASSWORD_HASH_SALT = secrets.PASSWORD_HASH_SALT
