# -*- coding: utf-8 -*-
from passport.backend.perimeter.settings.helpers import DEBUG


LOG_PATH = '' if DEBUG else '/var/log/yandex/perimeter/'

APP_LOGGER_NAME = 'flask'


LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'filters': {
        'request_id': {
            '()': 'passport.backend.perimeter.auth_api.logging_utils.filters.RequestIdFilter',
        },
    },
    'formatters': {
        'default': {
            'format': '%(process)d %(asctime)s %(name)-15s %(levelname)-10s %(message)s',
        },
        'request': {
            'format': '%(asctime)s %(request_id)s %(name)-15s %(levelname)-10s %(message)s',
        },
        'simple': {
            'format': "%(message)s"
        },
    },
    'root': {
        'handlers': ['debug', 'info', 'warning', 'exception'],
        'level': 'DEBUG',
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'level': 'DEBUG',
            'formatter': 'request',
            'filters': ['request_id'],
        },
        'debug': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'debug.log',
            'formatter': 'request',
            'filters': ['request_id'],
            'level': 'DEBUG',
        },
        'info': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'info.log',
            'formatter': 'request',
            'filters': ['request_id'],
            'level': 'INFO',
        },
        'warning': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'warning.log',
            'formatter': 'request',
            'filters': ['request_id'],
            'level': 'WARNING',
        },
        'exception': {
            'class': 'passport.backend.perimeter.auth_api.logging_utils.handlers.ExceptionHandler',
            'log_path': LOG_PATH,
            'filters': ['request_id'],
            'level': 'ERROR',
        },
    },
    'loggers': {
        # Логгеры для passport-core
        'passport.graphite_logger': {
            'handlers': [],
            'propagate': False,
        },
        'passport.useragent': {
            'handlers': ['debug', 'warning'],
            'level': 'WARNING',
            'propagate': False,
        },
        # Свои логгеры
        'perimeter.lazy_loader': {
            'handlers': ['debug', 'warning', 'exception'],
            'propagate': False,
        },
        'perimeter.ping': {
            'handlers': ['debug', 'warning', 'exception'],
            'propagate': False,
        },
        'flask': {
            'handlers': ['exception'],
        },
        'auth_logic': {
            'handlers': ['debug', 'warning', 'exception'],
            'propagate': False,
        },
        'views.auth': {
            'handlers': ['debug', 'info', 'warning', 'exception'],
            'propagate': False,
        },
        'views.status': {
            'handlers': ['debug', 'warning', 'exception'],
            'propagate': False,
        },
        'redis.checker': {
            'handlers': ['debug', 'warning', 'exception'],
            'propagate': False,
        },
        'ldap.checker': {
            'handlers': ['debug', 'warning', 'exception'],
            'propagate': False,
        },
        'db.checkers': {
            'handlers': ['debug', 'warning', 'exception'],
            'propagate': False,
        },
    }
}


if DEBUG:
    LOGGING['root']['handlers'].append('console')
    LOGGING['handlers']['exception'] = {
        'class': 'logging.FileHandler',
        'filename': 'exception.log',
        'formatter': 'default',
    }
