# -*- coding: utf-8 -*-
# isort:skip_file
import os
from imp import load_source


secret_settings = None

for config_file in (
    '/usr/lib/yandex/perimeter-secrets/settings.py',
    os.path.join(os.path.dirname(__file__), 'default.py'),
):
    try:
        secret_settings = load_source('secret_settings', config_file)
        break
    except IOError:
        pass

if not secret_settings:
    from passport.backend.perimeter.settings.secrets import default as secret_settings


# логин-пароль для пингования AD
LDAP_TEST_LOGIN = secret_settings.LDAP_TEST_LOGIN
LDAP_TEST_PASSWORD = secret_settings.LDAP_TEST_PASSWORD
# логин-пароль для доступа к БД
DB_USER = secret_settings.DB_USER
DB_PASSWORD = secret_settings.DB_PASSWORD
# пароль для redis
REDIS_PASSWORD = secret_settings.REDIS_PASSWORD
# соль для хэширования паролей в логах
PASSWORD_HASH_SALT = secret_settings.PASSWORD_HASH_SALT
