# -*- coding: utf-8 -*-
# isort:skip_file
import os

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'passport.backend.perimeter_api.settings.settings')

from django.core.wsgi import get_wsgi_application
from django.conf import settings
from passport.backend.library.configurator import Configurator
from passport.backend.library.wsgi_runner import Runner
from passport.backend.perimeter_api.perimeter_api.startup import prepare_environment


def main():
    prepare_environment()
    application = get_wsgi_application()
    config = Configurator(
        'perimeter_api',
        configs=[
            'base.yaml',
            'devserver.yaml' if settings.DEBUG else {},
        ],
    )
    runner = Runner(
        application,
        config=config,
    )
    runner.run()
