# -*- coding: utf-8 -*-
import logging

from passport.backend.core.logging_utils.formatters import ExceptionFormatter as BaseExceptionFormatter
from passport.backend.core.logging_utils.handlers import ExceptionHandler as BaseExceptionHandler
from passport.backend.core.logging_utils.helpers import mask_sensitive_fields
from passport.backend.perimeter_api.perimeter_api.globals import get_request


class ExceptionFormatter(BaseExceptionFormatter):
    def make_full_request_info(self, record):
        lines = []
        if record.request_id:
            lines.append('Request id: %s' % record.request_id)
        if record.request:
            lines.append('Path: %s' % record.request.path)
            lines.append('GET: %s' % mask_sensitive_fields(record.request.GET))
            lines.append('POST: %s' % mask_sensitive_fields(record.request.POST))
        return lines


class ExceptionHandler(BaseExceptionHandler):
    def __init__(self, log_path):
        super(ExceptionHandler, self).__init__(log_path, formatter_class=ExceptionFormatter)


class RequestIdFilter(logging.Filter):
    def filter(self, record):
        request = get_request()
        if request is not None:
            if not getattr(record, 'request', None):
                record.request = request
            record.request_id = request.headers.get('X-Request-Id') or ''
        else:
            # юнит-тесты, где реквеста просто нет
            record.request = None
            record.request_id = ''
        return True
