# -*- coding: utf-8 -*-
import logging

import django
from django.conf import settings as perimeter_api_settings
from passport.backend.core.conf import settings as passport_settings
from passport.backend.core.tvm import get_tvm_credentials_manager
from passport.backend.core.useragent import get_useragent
from passport.backend.utils.warnings import enable_strict_bytes_mode


log = logging.getLogger('startup')


def configure_settings():
    if not passport_settings.configured:
        passport_settings.configure(perimeter_api_settings)


def prepare_environment():
    log.debug('Preparing common environment...')

    django.setup()
    enable_strict_bytes_mode()
    configure_settings()

    get_useragent()
    get_tvm_credentials_manager()

    log.debug('Common environment prepared.')
