# -*- coding: utf-8 -*-
# Django settings for api project.
from imp import load_source
import os

from django_idm_api.settings import *  # noqa
import yenv


PROJECT_NAME = 'yandex-perimeter-api'

_current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))
IS_UNDER_TESTS = os.environ.get('YA_TEST_RUNNER')
DEBUG = IS_UNDER_TESTS or (yenv.type == 'development' and _current_user not in ('root', 'www-data'))

ADMINS = ()

MANAGERS = ADMINS

DATABASES = {
    'default': {
        'ENGINE': '',
        'HOST': '',
        'NAME': '',
        'PASSWORD': '',
    },
}

ALLOWED_HOSTS = ['*']

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# On Unix systems, a value of None will cause Django to use the same
# timezone as the operating system.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Moscow'

DATETIME_FORMAT = 'Y-m-d H:i'
DATE_FORMAT = 'Y-m-d'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'ru'

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale
USE_L10N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
STATIC_URL = '/media/'

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'create local_settings.py and add secret there'

MIDDLEWARE = (
    'django.middleware.common.CommonMiddleware',

    'passport.backend.perimeter_api.perimeter_api.middlewares.StoreRequestMiddleware',
    'passport.backend.perimeter_api.perimeter_api.middlewares.IDMAuthMiddleware',
    'passport.backend.perimeter_api.perimeter_api.middlewares.LoggingMiddleware',
)

ROOT_URLCONF = 'passport.backend.perimeter_api.perimeter_api.urls'

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',

    'passport.backend.perimeter_api.perimeter_api',
    'django_idm_api',
)

ROLES_HOOKS = 'passport.backend.perimeter_api.perimeter_api.roles_hooks.Hooks'
IDM_URL_PREFIX = 'dostup/'


if DEBUG:
    LOG_PATH = ''
else:
    LOG_PATH = '/var/log/yandex/perimeter-api/'

LOGGING = {
    'version': 1,
    'filters': {
        'request_id': {
            '()': 'passport.backend.perimeter_api.perimeter_api.logs.RequestIdFilter',
        },
    },
    'formatters': {
        'default': {
            'format': '%(asctime)s %(request_id)s %(name)-15s %(levelname)-10s %(message)s',
        },
    },
    'handlers': {
        'debug': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'debug.log',
            'formatter': 'default',
            'filters': ['request_id'],
            'level': 'DEBUG',
        },
        'exception': {
            'class': 'passport.backend.perimeter_api.perimeter_api.logs.ExceptionHandler',
            'log_path': LOG_PATH,
            'filters': ['request_id'],
            'level': 'ERROR',
        },
        'null': {
            'class': 'logging.NullHandler',
        },
    },
    'loggers': {
        # Логгеры для сторонних библиотек
        'requests': {
            'handlers': ['debug'],
            'level': 'WARNING',
            'propagate': False,
        },
        # Логгеры для passport-core
        'passport.useragent': {
            'handlers': ['debug'],
            'level': 'WARNING',
            'propagate': False,
        },
        'passport.graphite_logger': {
            'handlers': ['null'],
            'level': 'DEBUG',
            'propagate': False,
        },
    },
    'root': {
        'handlers': ['debug', 'exception'],
        'level': 'DEBUG',
    },
}


_PASSPORT_URLS = {
    'intranet': {
        'production': 'http://passport-internal.yandex-team.ru',
        'rc': 'http://passport-test-internal.yandex-team.ru',  # сюда ходит тестовый IDM, поэтому идём в тестовый паспорт
        'testing': 'http://passport-test-internal.yandex-team.ru',
        'development': 'http://passport-test-internal.yandex-team.ru',
    },
    'localhost': {
        'development': 'http://passport-test-internal.yandex-team.ru',
        'testing': '',
        'rc': '',
        'production': '',
    },
    'stress': {
        'stress': '',
    },
}

PASSPORT_URL = _PASSPORT_URLS[yenv.name][yenv.type]

PASSPORT_RETRIES = 2
PASSPORT_TIMEOUT = 1

PASSPORT_CONSUMER = 'perimeter_api'


TVM_KEYRING_CONFIG_NAME = 'perimeter-api'


try:
    load_source('local_settings', '/usr/lib/yandex/perimeter-api/local_settings.py')
    from local_settings import *  # noqa
except IOError:
    pass
