#!/usr/bin/perl

use lib::abs '../perl5/lib/perl5';

use strict;
use utf8;
use open qw(:std :utf8);

# it's all Apache stuff
use Apache ();
use Apache::DBI ();
use Apache::Registry ();
use Apache::Table ();

# some external libraries
use Digest::MD5 qw(md5_hex);         # different key generations
use Symbol ();      # for Pfile and Sendmail and Template
use File::Spec::Functions;

use Template ();
use Data::Dumper;

BEGIN {
    if(defined($Httpd::ROOT)) {
        unshift (@INC, $Httpd::ROOT);
        eval 'use SiteConf;';
        if($@) {
            print STDERR "Can't 'use SiteConf;'. ".
                         "Try to get values from defaults\n";
            $SiteConf::Flag = 0;
        }
        shift @INC;
    } else {
        print STDERR "Can't determine project source root\n";
        print STDERR "Check that variable \$Httpd::ROOT ".
                     "is set in httpd.conf\n";
        exit 0;
    }

    unshift(@INC, $Httpd::ROOT.'/cgi-bin/');
}

# Load configuration
use ADM::Conf;
use ADM::Guard;
use ADM::Template;
# now modules for precompilation
use ADM::Requester;
use ADM::Logs;
use ADM::Pfile;
use ADM::Core::DB;
use ADM::Core::ShardSearcher;
use ADM::Core::GlobalSearcher;
use ADM::Utils;

use DBAF::Safe;
use Input ();

use Conf;
use Common::Logs;
use Global;
use I18n;

use Log::Any::Adapter;
Log::Any::Adapter->set('+LogAnyAdapter');

$main::Conf = Conf->new();
if (!defined($main::Conf)) {
    ADM::Logs::IntErr("in StartUp: Conf loading failed");
    exit 0;
}

#############################################################################
#
# Init Config
$admin::Conf = ADM::Conf->new($httpdconf::admetcpath);
if (!defined($admin::Conf)) {
    ADM::Logs::IntErr("in StartUp: Conf loading failed");
    exit 0;
}
# поднимем фейковый $main::Conf, который будет импользоваться для совместимости с модулями по ветке cgi-bin,
# но при этом смотрит на файлы конфига для admin (PASSP-2263)
$main::Conf = $admin::Conf unless $main::Conf;

ADM::Logs::DeBug('I18n sources is loading');
my $i18n_dirpath = lib::abs::path('../i18n');
my $i18n = I18n->new;
$i18n->load_dir($i18n_dirpath);
my $langs = join ',', $i18n->langs;
ADM::Logs::DeBug("I18n sources has been loaded. Langs: $langs");
$Global::I18n = $i18n;

my $grants_filepath = $admin::Conf->GetVal('grants_filepath');
my $guard = ADM::Guard->new;
eval {
    if ($grants_filepath) {
        $guard->load_file($grants_filepath);
    }
};
if ($@) {
    ADM::Logs::IntErr("in StartUp: grants loading failed: $@");
    exit 0;
}
$admin::Guard = $guard;

#############################################################################
#  Preload and init Template Toolkit engine
#############################################################################
my $tmpl = $admin::Conf->GetVal('tmpl');
my $tmpl_cache = $admin::Conf->GetVal('tmplcache');
my $template_search_path = [ $tmpl ];

$admin::Template = Template->new({
        PRE_CHOMP => 0,
        POST_CHOMP => 0,
        TRIM => 0,
        ANYCASE => 0,
        INCLUDE_PATH => $template_search_path,
        ABSOLUTE => 0,
        RELATIVE => 1,
        RECURSION => 1,
        CACHE_SIZE => undef, # undef in this context means "cache all templates"
        COMPILE_EXT => ($tmpl_cache) ? '.compiled' : undef,
        COMPILE_DIR => $tmpl_cache,
        FILTERS => {
            'js' => sub {
                my $str = shift;
                return '' unless(defined($str));
                $str =~ s/(['"])/\\$1/g;
                $str =~ s/\n/\\n/g;
                $str =~ s/\f/\\f/g;
                $str =~ s/\r/\\r/g;
                $str =~ s/\t/\\t/g;
                return $str;
            },
            'otrs' => sub {
                my $str = shift;
                return '' unless(defined($str));
                $str =~ s/ #?(\d{15,})/<a target="_blank" href="https:\/\/otrs.yandex-team.ru\/$1">Ticket<\/a>/g;
                return $str;
            },
        },
        ENCODING => 'utf8',
});
if ($tmpl_cache){
    foreach my $dir ($tmpl){
        next if !$dir;
        my $fullpath = File::Spec->catdir($tmpl_cache, $dir);
        if (!(-d $fullpath)){
            ADM::Logs::IntErr("Template Toolkit failed to create cache directory $fullpath, check permissions of root user");
            exit(0);
        }
        my $rc = chmod 0777, $fullpath;
        if (!$rc){
            ADM::Logs::IntErr("Cannot chmod cache directory $fullpath: $!");
            exit(0);
        }
    }
}
#
#############################################################################

1;
