/**
* Checkbox Selector
* 
* Для работы необходимо подключение фреймворка jQuery (http://docs.jquery.com/Downloading_jQuery)
* @alias http://code.jquery.com/jquery-1.1.2.js
* Для использования:
* select_area - заменить значение на id таблицы
* select_class - CSS класс который формляет выделение записи в таблице
* chbox_class -  подставить класс - если есть он есть у чекбоксов, если не объявлять - для выделения будут использоваться все чекбоксы внутри select_area
* $type(myString); //returns "string"
*/

var select_area = 'select_area';
var chbox_class = null;
var select_class = 'selected';


var UNDEF = 'undefined';
var chb_path = chbox_class ? "input."+ chbox_class + "]" : "input[type='checkbox']";
var selector_area_path = "table[id = '" + select_area + "']"

var selecting = false;
var makeSelect = true;
var isFirstSelect = true;


function selectRow(checkbox){
    var row = checkbox.parent().parent();
    row.addClass(select_class);
    checkbox.attr('checked', true);
    return true;
}

function unselectRow(checkbox){
    var row = checkbox.parent().parent();
    row.removeClass(select_class);
    checkbox.attr('checked', false);
    return true;
}

function checkForSelect(obj){
    if(selecting){
        if(isFirstSelect){
            makeSelect = !obj.attr('checked');
            isFirstSelect = false;
        }
        return (makeSelect) ? selectRow(obj) : unselectRow(obj);
    }
    return true;
}

function startSelecting(obj){
    selecting = true;
    isFirstSelect = true;
    return checkForSelect(obj);
}

function stopSelecting(){
    selecting = false;
    isFirstSelect = true;
    return true;
}

function SelAll(id, obj){
    var select = obj.attr('checked');
    $("form#" + id + " " + chb_path).not("[name=sel_all]").each(function(){
        return select ? selectRow($(this)) : unselectRow($(this));
    });
}
