# Conf from passport project
# coding: utf8
#
# Configuration module for bebe
#
# Yandex, 2008
#
# $Id: Conf.pm,v 1.39 2008/01/29 13:48:59 torubarov Exp $
#
package ADM::Conf;
use strict;
use utf8;
use open qw(:std :utf8);
#use Exporter;
use Config::ApacheFormat;
use ADM::Logs;
use POSIX ();
use Net::Netmask;
use Net::Patricia;

use vars qw(@ISA @EXPORT %Files %Tokens %ConfCache %Helpers $ConfDir %HardCoded);

BEGIN {
    # Pre-init
    %Files = (
        'passport.conf' => {
            'reload' => 0,
            'timestamp' => 0,
            'config' => undef,
            'tokens' => [
# Host ID for logs and various pathes:
                'this_host_id',
                'log_path',
                'child_log_path',
                'lock_root',

                'auth_new_log_enabled',
                'auth_new_log_file',
                'event_log_enabled',
                'event_log_file',
                'client_name',
# Template pathes
                'tmpl',
                'tmplcache',
# основной урл валидатора телефонов
                'phone_validator_url',
                'yandexteam',
# intergration with other admin-faces
                'friends_service_status_url',
                'blackbox_url',
                'team_blackbox_url',
                'team_mda_url',
                'team_passport_url',
                'passport_backend_host',
                'root_cookie',

# список допустимых доменов                
                'allowed_domains',
# DebugLevel
                'passport_url',
                'debug_level',
                'debug_log_file_level',
# задержка удаления логинов из таблицы reserved_logins
                'reserved_login_delay',

                'historydb2_start_date',
                'historydb3_start_date',
                'historydb3_proxy',

                'blackbox_group_max_size',
                'background_tasks_path',
                'base_url',

                'grants_filepath',

                'key_diag_public_key',
                'key_diag_private_key',
            ],
        },

        'access.conf' => {
            'reload' => 1,
            'timestamp' => 0,
            'config' => undef,
            'tokens' => [
                'allow_from',
            ],
        },
    );


    # user with this services should not be dropped, just blocked instead
    $HardCoded{'Protected'} = {
        14 => 1, # Директ
        15 => 1, # Платёжный пароль
        18 => 0, # Сфера не используется
        19 => 1, # Баланс-Билинг
        20 => 1, # Деньги
        21 => 0, # Клиентский Интерфейс (КИ)
        24 => 1, # Рекламная Сеть (бывший Партнерский Интерфейс (ПИ))
        25 => 0, # Маркет
        28 => 0, # Кубок Яндекса
        32 => 0, # CRM
        64 => 1, # Оплаченный Диск
        78 => 1, # Мобильное приложение Музыки
        85 => 1, # Новый Партнерский Интерфейс
        100 => 0, # Принудительная смена пароля и контрольного вопроса на след. входе
        104 => 1, # Администратор ПДД домена
        116 => 1, # Толока
        117 => 1, # Телефония
        119 => 1, # Инвестиции
        670 => 1, # Корпоративный аккаунт
    };

    $HardCoded{'HistoryAuthTypeNameToId'} = {
        unknown     =>  0,
        web         =>  1,
        autologin   =>  2,
        token       =>  3,
        ftp         =>  4,
        xmpp        =>  5,
        smtp        =>  6,
        pop         =>  7,
        imap        =>  8,
        icq         =>  9,
        sauth       => 10,
        calendar    => 11,
        oauth       => 12,
        oauthcheck  => 13,
        oauthcreate => 14,
    };

    $HardCoded{'HistoryAuthStatusNameToId'} = {
        successful    =>  1,
        disabled      =>  2,
        failed        =>  3,
        blocked       =>  4,
        ses_kill      =>  5,
        ses_create    =>  6,
        ses_update    =>  7,
        secses_kill   =>  8,
        secses_create =>  9,
        secses_update => 10,
        safeses_sync  => 11,
        bruteforce    => 12,
    };

    %Tokens = ();
    %ConfCache = ();
    while (my ($confname, $settings) = each(%Files)){
        if (defined ($settings->{'tokens'}) && (ref($settings->{'tokens'}) eq 'ARRAY')){
            foreach my $token (@{$settings->{'tokens'}}){
                $Tokens{$token} = $confname;
                $ConfCache{$token} = undef;
            }
        }
    }

    # f -- handler
    # n -- Name in .conf file
    # d -- default value
    # m -- flag, must be defined
    # t -- type
    %Helpers = (
# passport.conf
# Host ID for logs and various pathes:
        'debug_log_file_level' => {'f' => \&_plainvalue, 'n' => 'DebugLogFileLevel', 'd' => 0},
        'this_host_id' => {'f' => \&_plainvalue, 'n' => 'ThisHostID', 'm' => 1},
        'log_path' => {'f' => \&_plainvalue, 'n' => 'LogPath', 'm' => 1, 't' => 'DIR',},
        'child_log_path' => {'f' => \&_plainvalue, 'n' => 'ChildLogPath', 'm' => 1, 't' => 'DIR',},
        'lock_root' => {'f' => \&_plainvalue, 'n' => 'LockRoot', 'm' => 1, 't' => 'DIR',},

        'auth_new_log_enabled' => { f => \&_plainvalue, n => 'AuthNewLogEnabled', m => 0, d => 1             },
        'auth_new_log_file'    => { f => \&_plainvalue, n => 'AuthNewLogFile',    m => 0, d => 'authnew.log' },
        'event_log_enabled'    => { f => \&_plainvalue, n => 'EventLogEnabled',   m => 0, d => 1             },
        'event_log_file'       => { f => \&_plainvalue, n => 'EventLogFile',      m => 0, d => 'event.log'   },
        'client_name'          => { f => \&_plainvalue, n => 'ClientName',        m => 0, d => 'admin' },

# Template pathes
        'tmpl' => {'f' => \&_plainvalue, 'n' => 'TMPL', 'm' => 1, 't' => 'DIR',},
        'tmplcache' => {'f' => \&_plainvalue, 'n' => 'TMPLCACHE', 't' => 'DIR',},
# основной урл телефонного валидатора
        'phone_validator_url' => {'f' => \&_plainvalue, 'n' => 'PhoneValidatorUrl', 'm' => 1},
        'yandexteam' => {'f' => \&_plainvalue, 'n' => 'YandexTeam', 'd' => '0',},
# intergration with other admin-faces
        'friends_service_status_url' => { f => \&_plainvalue, n => 'FriendsServiceStatusUrl', m => 1 },
# урлы до ЧЯ
        'blackbox_url'      => { f => \&_plainvalue, n => 'BlackboxUrl', m => 1 },
        'team_blackbox_url' => { f => \&_plainvalue, n => 'TeamBlackboxUrl', m => 1 },
        'team_mda_url'      => { f => \&_plainvalue, n => 'TeamMdaUrl',      m => 1 },
        'team_passport_url' => { f => \&_plainvalue, n => 'TeamPassportUrl', m => 1 },
        'passport_backend_host' => { f => \&_plainvalue, n => 'PassportBackendHost', m => 1 },

        'root_cookie' => {'f' => \&_plainvalue, 'n' => 'RootCookie', 'd' => '.yandex.ru' },

# список допустимых доменов
        'allowed_domains' => {'f' => \&_plainvalue, 'n' => 'AllowedDomains', 'd' => 'yandex.ru,yandex.com,yandex.com.tr,yandex-team.ru'},
        
        'passport_url' => { f => \&_plainvalue, n => 'PassportUrl', m => 0, d => 'https://passport.yandex.ru' },
# DebugLevel
# 0 - no debug
# 1 - fatal errors reported
# 2 - nonfatal errors reported
# 3 - all possible debug is on
        'debug_level' => {'f' => \&_plainvalue, 'n' => 'DebugLevel', 'd' => 0,},
# задержка удаления логинов из таблицы reserved_logins (месяцы) 
        'reserved_login_delay' => {'f' => \&_plainvalue, 'n' => 'ReservedLoginDelay', 'd' => 6,},        

        'historydb2_start_date' => {'f' => \&_plainvalue, 'n' => 'HistoryDb2StartDate', d => '2010-04-19'},
        'historydb3_start_date' => {'f' => \&_plainvalue, 'n' => 'HistoryDb3StartDate', d => '2013-11-16'},
        'historydb3_proxy'      => {'f' => \&_plainvalue, 'n' => 'HistoryDb3Proxy',     d => 'historydb-api.passport.yandex.net'},

        'blackbox_group_max_size' => {'f' => \&_plainvalue, 'n' => 'BlackboxGroupMaxSize', d => 100},
        'background_tasks_path'   => {'f' => \&_plainvalue, 'n' => 'BackgroundTasksPath',  d => '/opt/tmp/admin-background-tasks' },
        'base_url'                => {'f' => \&_plainvalue, 'n' => 'BaseUrl',              d => 'https://adm.yandex-team.ru' },

        'grants_filepath'         => {'f' => \&_plainvalue, 'n' => 'GrantsFilepath', d => '' },

        'key_diag_public_key'     => {'f' => \&_plainvalue, 'n' => 'KeyDiagPublicKey',  d => '' },
        'key_diag_private_key'    => {'f' => \&_plainvalue, 'n' => 'KeyDiagPrivateKey', d => '' },
# /passport.conf

# access.conf
        'allow_from' => {'f' => \&_allowfrom, 'n' => 'AllowFrom'},
# /access.conf
    );
};

sub new {
    my ($proto, $etcpath, %args)  = @_;

    $ConfDir = undef;
    if ($etcpath && (-d $etcpath)){
        $ConfDir = $etcpath;
    }

    unless ($ConfDir && (-d $ConfDir)){
        ADM::Logs::IntErr("Cannot discover etc directory");
        return undef
    }

    my $class = ref($proto) || $proto;
    my $this = {};
    bless($this, $class);
    if ($this->init(%args)){
        return $this;
    } else{
        return undef;
    }
}

sub init {
    my ($this, %args) = @_;

    if ($this->LoadFiles && $this->InitHardcode){
        return 1;
    } else {
        return undef;
    }
}

sub _plainvalue;

sub LoadFiles {
    my ($this) = @_;

    unless (defined($this)){
        ADM::Logs::IntErr('Bad call of LoadFiles');
        return undef;
    }

    foreach my $filename (keys %Files){
        unless ($this->_loadfile($filename)){
            ADM::Logs::DeBug("Configuration not loaded from $filename");
        }
    }

    return 1;
}

sub GetValByPos {
    my ($this, $pos, @tokens) = @_;
    unless (defined($this)){
        ADM::Logs::IntErr('Bad call of GetValByPos');
        return undef;
    }
    if (!$pos || $pos !~ /^(\d+)$/) {
        $pos = 0;
    }
    my $token = $tokens[$pos];
    return undef if (!defined $token);
    return $this->GetVal($token);
}

sub GetVal {
    my ($this, @tokens) = @_;

    unless (defined($this)){
        ADM::Logs::IntErr('Bad call of GetVal');
        return undef;
    }
    return undef unless (scalar(@tokens));

    # Check what files are to be reloaded for this list of tokens
    my %filestoread = ();
    foreach my $token (@tokens){
        unless(defined($Tokens{$token})){
            ADM::Logs::IntErr("Unknown token $token requested in GetVal, will return undefined value");
            next;
        }
        $filestoread{$Tokens{$token}} = 1;
    }

    # Refresh all needed files

    foreach my $filename (keys(%filestoread)){
        unless ($this->_loadfile($filename)){
            ADM::Logs::IntErr("Config file $filename not loaded");
        }
    }

    my @rv = ();

    foreach my $token (@tokens){
        push @rv, $ConfCache{$token};
    }

    return wantarray ? @rv : $rv[0];

}

sub _readval {
    my ($this, $token, $conf) = @_;

    unless (defined($this)){
        ADM::Logs::IntErr('Bad call of _readval');
        return undef;
    }
    return(undef, 'Token to read is not specified') unless ($token);
    return(undef, 'Undefined conf object') unless (defined($conf));
    return(undef, "Unknown token $token") unless (defined($Tokens{$token}));
    return(undef, "Helper for token $token is not defined") unless (defined($Helpers{$token}));

    my ($rv, $error) = &{$Helpers{$token}->{'f'}}($token, $conf, $Helpers{$token});

    return (undef, $error) if (!defined($rv) && $error);

    return $rv;
}

sub _loadfile {
    my ($this, $filename) = @_;

    unless (defined($this) && $filename){
        ADM::Logs::IntErr('Bad call of _loadfile');
        return undef;
    }
    unless (defined($Files{$filename})){
        ADM::Logs::IntErr("In _loadfile: unknown config filename $filename");
        return undef;
    }
    if (!$Files{$filename}->{'reload'} && $Files{$filename}->{'timestamp'}) {
        return 1;
    }
    my $filepath = File::Spec->catfile($ConfDir, $filename);
    unless (-f $filepath){
        ADM::Logs::IntErr("Config file $filepath does not exists");
        return undef;
    }

    my $mtime = (stat("$filepath"))[9];
    if ($Files{$filename}->{'reload'} && $Files{$filename}->{'timestamp'} == $mtime) {
        return 1;
    }

    my %default_config_options = (
        inheritance_support => 0,
        include_support => 0,
        autoload_support => 0,
        case_sensitive => 0,
        fix_booleans => 1,
        expand_vars => 0,
        setenv_vars => 0,
        duplicate_directives => 'combine',
    );

    my $config = Config::ApacheFormat->new(defined($Files{$filename}->{'options'}) ?
                                                   %{$Files{$filename}->{'options'}} :
                                                   %default_config_options);
    $config->read($filepath);

    my $curtime = time;

    if (defined($Files{$filename}->{'tokens'}) &&
        (ref($Files{$filename}->{'tokens'}) eq 'ARRAY')){
        foreach my $token (@{$Files{$filename}->{'tokens'}}){
            my ($confvalue, $error) = $this->_readval($token, $config);
            if (!defined($confvalue) && $error){
                ADM::Logs::IntErr("Error loading configuration for token $token: $error");
                return undef;
            }
            $ConfCache{$token} = $confvalue;
        }
    }
    ADM::Logs::DeBug("Configuration file $filename " . ($Files{$filename}->{'timestamp'} ? 're' : '') . 'loaded');

    $Files{$filename}->{'config'} = $config;
    $Files{$filename}->{'timestamp'} = $mtime;
}

sub _plainvalue {
    my ($token, $conf, $args) = @_;

    unless ($token){
        return (undef, "Token is not specified in _plainvalue call");
    }
    unless (defined($conf)){
        return (undef, "Conf object is not defined in _plaivalue call for token $token");
    }

    my $name = $args->{'n'};
    $name ||= $token;

    my $rv = $conf->get($name);

    if (!defined($rv) && $args->{'m'}){
    }
    if (!defined($rv)){
        if ($args->{'m'}){
            return (undef, "Mandatory value for \"$token\" (name \"$name\") not found in config");
        } elsif (defined($args->{'d'})){
            ADM::Logs::DeBug("Value for \"$token\" (name \"$name\") not found in config, setting default");
            return $args->{'d'};
        } else {
            return $rv;
        }
    }

    if ($args->{'t'}){
        if ($args->{'t'} eq 'HOSTNAME'){
            $rv =~ s,/+$,,;
            $rv .= '/';
        } elsif ($args->{'t'} eq 'NATURAL'){
        }
    }

    return $rv;
}

sub _database {
    my ($token, $conf, $args) = @_;

    unless ($token){
        return (undef, "Token is not specified in _database call");
    }
    unless (defined($conf)){
        return (undef, "Conf object is not defined in _database call for token $token");
    }
    unless (defined($conf)){
        return (undef, "Conf object is not defined in _database call for token $token");
    }
    my $blockname = $args->{'n'};

    unless ($blockname){
        return (undef, "Block name (\$args->{'n'}) is not defined in _database call for token $token");
    }
    my $block = $conf->block(Database => $blockname);
    unless ($block){
        return (undef, "Required <Database $blockname> block not found in config");
    }
    my $dsn = $block->get('DSN');
    my $dbuser = $block->get('DBUser');
    my $dbpasswd = $block->get('DBPassword');
    unless ($dsn && $dbuser && defined($dbpasswd)){
        return (undef, "Error parsing config: DSN, DBUser and DBPassword are required values for <Database $blockname> block in config");
    }
    my $attr = {};
    foreach my $key (qw{RaiseError PrintError}) {
        my $val = $block->get($key);
        if(defined($val)) {
            $attr->{$key} = $val;
        }
    }
    return {'src' => $dsn, 'user' => $dbuser, 'passwd' => $dbpasswd, 'attr' => $attr};
}

sub _allowfrom {
    my ($token, $conf, $args) = @_;

    unless ($token){
        return (undef, "Token is not specified in _allowfrom call");
    }
    unless (defined($conf)){
        return (undef, "Conf object is not defined in _allowfrom call");
    }

    my $name = $args->{'n'};

    unless ($name){
        return(undef, "Variable name (\$args->{'n'}) is not defined in _allowfrom call");
    }

    my $all_modes = {};
    my @entries = $conf->get($name);
    foreach my $entry (@entries){
        my $block = $conf->block($entry);
        my $mode = $entry->[1];

        my @ips = $block->get('IP');
        my $curr_ip;
        foreach my $ip (@ips) {
            my $ipo = IP->new($ip);
            if ($ipo->is_valid) {
                if ($all_modes->{$mode}->{'allow-ip'}->{$ip}){
                    ADM::Logs::ConfErr("Semantic dublicate ip $ip in <$name $mode> block, ignoring");
                    next;
                }
                $all_modes->{$mode}->{'allow-ip'}->{$ip} = {};
            } elsif ($ip =~ /^([a-z]+)$/ && defined($curr_ip)) {
                my $from = $ip;
                $all_modes->{$mode}->{'allow-ip'}->{$curr_ip}->{'from'}->{$from} = 1;
            } else {
                ADM::Logs::ConfErr("Bad IP $ip in <$name $mode> block, ignoring");
                undef $curr_ip;
                next;
            }
        }

        my $patricia6 = Net::Patricia->new(AF_INET6);

        my @subnets = $block->get('SUBNET');
        my $curr_subnet;
        foreach my $subnet (@subnets) {
            if ($subnet =~ /:/) {
                eval {
                    $patricia6->add_string($subnet, $subnet);
                };

                if ($@) {
                    Common::Logs::ConfErr("Bad SUBNET $subnet in <$name $mode> block, ignoring");
                }

                next;
            }

            my $block = new2 Net::Netmask($subnet);
            if (defined($block)) {
                $curr_subnet = $subnet;
                if ($all_modes->{$mode}->{'allow-subnet'}->{$subnet}){
                    ADM::Logs::ConfErr("Semantic dublicate SUBNET $subnet in <$name $mode> block, ignoring");
                    next;
                }
                $all_modes->{$mode}->{'allow-subnet'}->{$subnet} = {};
                $all_modes->{$mode}->{'allow-subnet'}->{$subnet}->{'block'} = $block;
            } elsif ($subnet =~ /^([a-z]+)$/ && defined($curr_subnet)) {
                my $from = $subnet;
                $all_modes->{$mode}->{'allow-subnet'}->{$curr_subnet}->{'from'}->{$from} = 1;
            } else {
                ADM::Logs::ConfErr("Bad SUBNET $subnet in <$name $mode> block, ignoring");
                undef $curr_subnet;
                next;
            }
        }

        $all_modes->{$mode}->{'allow-patricia6'} = $patricia6;
    }

    return $all_modes;
}

sub GetHCVal {
    my ($this, @tokens) = @_;

    my @rv = ();
    foreach my $token (@tokens){
        if (defined($HardCoded{$token})) {
            push @rv, $HardCoded{$token};
        } else {
            ADM::Logs::ConfErr("Conf hardcoded object not defined for token '$token'");
            push @rv, undef;
        }    
    }    
    return wantarray ? @rv : $rv[0];
}

sub InitHardcode {
    my ($this) = @_;

    $HardCoded{'YandexDomains'} = {
        'yandex.ru'  => 1,
        'yandex.ua'  => 1,
        'yandex.com' => 1,
        'yandex.by'  => 1,
        'yandex.kz'  => 1,
        'ya.ru'      => 1,
        'narod.ru'   => 1,
        'яндекс.рф'  => 1,
    };

    return 1;
}

1;
