# Base package for database modules
#
# $Id: DB.pm 23295 2008-10-06 14:11:08Z torubarov $
#
package ADM::Core::DB;
use strict;
use utf8;
use open qw(:std :utf8);
use DBI;

use DBAF;
use Passport;

use base qw(
    ADM::Core::Passport
);

sub new {
    my $this = shift;
    unless(defined($this)) {
        return undef;
    }
    my $class = ref($this) || $this;
    my $self = {};
    bless $self, $class;

    unless ($self->initialize()) {
        return undef;
    }

    return $self;
}

sub initialize {
    my $self = shift;

    $self->setdberror();
    $self->dbaf;

    return 1;
}

sub dberror {
    my $self = shift;
    return $self->{'_ERROR'};
}

sub setdberror {
    my ($self, $error) = @_;
    unless (defined($error)) {
        $error = '';
    }
    $self->{'_ERROR'} = $error;
    if ($error) {
        ADM::Logs::DbErr($error . " [" . join('-', (caller)[0, 2]) . "]");
    }
    return 1;
}

sub dbaf {
    my $self = shift;

    my $dbaf = DBAF->instance;
    unless ($dbaf) {
        $dbaf = DBAF->NewDBAF;
        $dbaf->NewSAFE;
        $dbaf->uid_collection(Passport::db_init_uid_collection('admsharddbslave'));
        $dbaf->central_group(Passport::db_init_central_group('admcentraldbslave'));
        $dbaf = DBAF->instance;
    }

    return $dbaf;
}

1;
