package ADM::Engine::Alive;

use common::sense;

use Apache::Constants 'OK';
use Log::Any '$log';
use Cwd 'realpath';

use ADM::Logs;
use ADM::Core::DB;
use Passport;

sub handler {
    my $req = shift;

    my $result = 0;

    $result = eval {
        my $acd = get_acd();

        check_ping_file();
        check_central($acd);
        check_shards($acd);

        return 1;
    };

    if ($result) {
        ADM::Logs::DeBug("ALIVE: result=1");
    }
    else {
        ADM::Logs::AdMin("ALIVE: result=0 exception=$@")
    }

    $req->header_out('Content-Charset', 'windows-1251');
    $req->content_type('text/html'); 

    my $status = $result ? 200 : 500;
    $req->status($status);
    $req->send_http_header;
    $req->print("Pong\n")
      if $result;

    return OK;
}

sub get_acd {
    my $acd = ADM::Core::DB->new;
    die "can't create db object"
      unless $acd;
    return $acd;
}

sub check_central {
    my $acd = shift;

    my $slave = $acd->dbaf->central_group->slave;
    my $dbh = $slave->dbh;

    die "central slave is down; dsn=" . $slave->get_dsn
      unless $dbh->ping;
}

sub check_shards {
    my $acd = shift;

    my $uid_collection = $acd->dbaf->uid_collection;
    my $slaves = $uid_collection->slaves;

    for my $slave (@$slaves) {
        my $dbh = $slave->dbh;

        die $slave->group_name . " slave is down; dsn=" . $slave->get_dsn
          unless $dbh->ping;
    }
}

sub check_ping_file {
    my $tmpl = $admin::Conf->GetVal('tmpl');
    my $home = realpath("$tmpl/../..");
    my $path = "$home/data/ping.html";

    open my $file, '<', $path
      or die "ping file is down: $!";
}

1;
