package ADM::FakeInput;

=head1 NAME

ADM::FakeInput

=head1 DESCRIPTION

Модуль необходим при работе с веткой cgi-bin, т.к. во многих местах там требуется наличие переменной пакета $Input::*
"Fake" в названии модуля подчёркивает, что это скорее имитация модуля Input из ветки cgi-bin и имеет весьма урезанный функционал.

=head1 NOTES

Пока используется в хэндлере Engine::User для корректной работы AIO::Requester, по uri /users/warn/ (PASSP-2263)

=cut

use strict;
use warnings;

use utf8;

use IP;

$Input::Input = {};

sub InitInput {
    my ($req) = @_;
    
    # забираем ip
    my $ip = $req->header_in('X-Real-IP') || $req->connection->remote_ip;
    my $via = $req->header_in('Via');               # set by SQUID
    my $xff = $req->header_in('X-Forwarded-For');   # set by SQUID
    my $fwd = $req->header_in('Forwarded');         # set by Netscape
    my $pxy = $req->header_in('Proxy-User');        # set by Netscape

    # определимся: что есть прокси, а что есть ip клиента
    my $proxy = '';    
    if(defined $xff) {
        # if seems to be SQUID
        $proxy = $ip;
        $ip = $xff;
    } elsif(defined $fwd and defined $pxy) {
        # if seems to be Netscape
        $proxy = $ip;
        $ip = $pxy;
    } elsif(defined $fwd) {
        # if we still think it's proxied
        $proxy = $ip;
        if($fwd =~ m/for (\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})/) {
            $ip = "$1.$2.$3.$4";
        } else {
            $ip = '';
        }
    }
 
    my $input = FakeInputInput->new;

    $input->{real_ip} = IP->new($proxy || $ip);
    $input->{ip_from} = IP->new($ip);
    $input->{ip_prox} = IP->new($proxy)
      if $proxy;

    $Input::Input = $input;
    
    return 1;
};


package FakeInputInput;

sub new { bless {}, shift }

sub lang { 'en' }

1;
