# Package for different logs
# $Id: Logs.pm,v 2.36 2008/05/08 14:39:22 torubarov Exp $ $Name:  $
#
package ADM::Logs;
use strict;
use utf8;
use open qw(:std :utf8);
use POSIX qw(strftime);

use History::Logger;
use History::Converter::PassportChanges;

sub IntErr($);
sub DeBug($);

my $history_logger;
my $changes_converter;

sub Init {
    return if $history_logger;

    $history_logger = History::Logger->new(
        host_id     => $admin::Conf->GetVal('this_host_id'),
        client_name => $admin::Conf->GetVal('client_name'),

        auth_log_path  => File::Spec->catfile($admin::Conf->GetVal('child_log_path', 'auth_new_log_file')),
        event_log_path => File::Spec->catfile($admin::Conf->GetVal('child_log_path', 'event_log_file')),

        pfile_write_code_ref => \&ADM::Pfile::PWrite,
        pfile_close_code_ref => \&ADM::Pfile::PClose,
        log_admin_code_ref   => \&ADM::Logs::AdMin,
        log_interr_code_ref  => \&ADM::Logs::IntErr,
    );
    die "i can't create history logger instance!" unless $history_logger;

    $changes_converter = History::Converter::PassportChanges->new(
        log_admin_code_ref   => \&ADM::Logs::AdMin,
        log_debug_code_ref   => \&ADM::Logs::DeBug,
    );
    die "i can't create changes converter instance!" unless $changes_converter;
}

sub LogChanges {
    my ($opdata, $changes) = @_;
    unless( defined($opdata) and
            defined($changes) ){
        DeBug("In LogChanges: bad parameters")
            if($admin::Conf->GetVal('debug_level'));
        return undef;
    }

    LogEventsAsChanges($opdata, $changes);

    return 1;
}

sub LogEventsAsChanges {
    return 1 unless $admin::Conf->GetVal('event_log_enabled');

    Init();

    my ($opdata, $changes) = @_;

    my $admin = delete $changes->{admin_login} || delete $changes->{admin_edit}; # в admin_edit при mode=admin лежит uid админа
    my $comment = delete $changes->{admin_comment} || undef;
    my $target = {
        uid => $opdata->{uid},
    };
    my $caller = {
        ip_from => $opdata->{ip_from},
        ip_prox => $opdata->{ip_prox},
        yandexuid => delete $changes->{yandexuid},
    };
    my $events = $changes_converter->convert($opdata, $changes);
    
    return $history_logger->log_events(
        'caller' => $caller,
        target   => $target,
        events   => $events,
        admin    => $admin,
        comment  => $comment,
    );
}

sub IntErr($) {
    my $msg = shift;
    my ($package, undef, $line) = caller;
    $msg ||= 'Unknown error. Bad ADM::Logs::IntErr() call.';
    $msg =~ s,[\r|\n]+,^M,g;
    print STDERR "[" . localtime() . "] [interror] " . $msg . " (" . $package . ":" . $line . ")\n";
}

sub DeBug($) {
    my $msg = shift;
    my ($package, undef, $line) = caller;
    $msg ||= 'Unknown debug message. Bad ADM::Logs::DeBug() call.';
    $msg =~ s,[\r|\n]+,^M,g;
    print STDERR "[" . localtime() . "] [debug] " . $msg . " (" . $package . ":" . $line . ")\n";
}

sub AdMin($) {
    my $msg = shift;
    my ($package, undef, $line) = caller;
    $msg ||= 'Unknown admin message. Bad ADM::Logs::AdMin() call.';
    $msg =~ s,[\r|\n]+,^M,g;
    print STDERR "[" . localtime() . "] [admin] " . $msg . " (" . $package . ":" . $line . ")\n";
}

sub DBConnectErr($) {
    my $msg = shift;
    my ($package, undef, $line) = caller;
    $msg ||= 'Unknown database connect error message. Bad ADM::Logs::DBConnectErr() call.';
    $msg =~ s,[\r|\n]+,^M,g;
    print STDERR "[" . localtime() . "] [dbconnect] " . $msg . " (" . $package . ":" . $line . ")\n";
}

sub DbErr($) {
    my $msg = shift;
    my ($package, undef, $line) = caller;
    $msg ||= 'Unknown database error message. Bad ADM::Logs::DbErr() call.';
    $msg =~ s,[\r|\n]+,^M,g;
    print STDERR "[" . localtime() . "] [dberror] " . $msg . " (" . $package . ":" . $line . ")\n";
}

sub TplErr($) {
    my $msg = shift;
    my ($package, undef, $line) = caller;
    $msg ||= 'Unknown template error. Bad ADM::Logs::TplErr() call.';
    $msg =~ s,[\r|\n]+,^M,g;
    print STDERR "[" . localtime() . "] [template] " . $msg . " (" . $package . ":" . $line . ")\n";
}

sub ConfErr($) {
    my $msg = shift;
    my ($package, undef, $line) = caller;
    $msg ||= 'Unknown config error. Bad ADM::Logs::ConfErr() call.';
    $msg =~ s,[\r|\n]+,^M,g;
    print STDERR "[" . localtime() . "] [configuration] " . $msg . " (" . $package . ":" . $line . ")\n";
}

sub Test($) {       # Test DeBug (to swith off in one place for production)
#    DeBug( $_[0] );
}

1;
