# Package for maintaining persisten file handlers throughout child life
# $Id: Pfile.pm,v 2.6 2008/05/08 13:31:18 torubarov Exp $ $Name:  $
#
package ADM::Pfile;
use strict;
use utf8;
use Fcntl;
use Global;

%ADM::Pfile::bundle = ();

# function for opening persisten (through the childe's life) 
sub POpen {
    my ($fname) = @_;
    unless(defined($fname) and $fname) {
        return undef;
    }
    if(defined($ADM::Pfile::bundle{$fname})) {
        if (-e $fname) {
            return $ADM::Pfile::bundle{$fname};
        } else {
            PClose($fname);
        }
    }
    my $tmphandle = Symbol::gensym;
    my $res;
    if(-e $fname) {
        $res = sysopen($tmphandle, $fname, O_WRONLY|O_APPEND|O_NONBLOCK);
    } else {
        $res = sysopen($tmphandle, $fname, O_WRONLY|O_APPEND|O_CREAT|O_NONBLOCK);
    }
    if($res) {
        $ADM::Pfile::bundle{$fname} = $tmphandle;
        return $tmphandle;
    } else {
        ADM::Logs::DeBug("in POpen: can't open file $fname: $!")
            if($admin::Conf->GetVal('debug_level'));
        return undef;
    }
}

sub PClose {
    my ($fname) = @_;
    unless (defined($fname) and ($fname)){
        ADM::Logs::DeBug("in PClose: can't close file: called without filename");
        return undef;
    }
    if (defined($ADM::Pfile::bundle{$fname})){
        my $rc = close $ADM::Pfile::bundle{$fname};
        delete $ADM::Pfile::bundle{$fname};
        unless ($rc){
            ADM::Logs::DeBug("in PClose: can't close file $fname: $!");
            return undef;
        } else{
            return 1;
        }
    } else{
        return 0;
    }
}
    
sub PWrite {
    my ($fname, $string, $encoding_preset) = @_;
    unless(defined($fname) and defined($string)){
        ADM::Logs::DeBug("In DoLog: bad parameters")
            if($admin::Conf->GetVal('debug_level'));
        return undef;
    }
    my $handle = POpen($fname);
    unless(defined($handle)){
        return undef;
    }
    $encoding_preset ||= 'log';
    Global::EncodeAll($string, 'inner', $encoding_preset);
    unless(syswrite($handle, $string, length($string))) {
        ADM::Logs::DeBug("In DoLog: error writing log: $!")
            if($admin::Conf->GetVal('debug_level'));
        return undef;
    }
    return 1;
}

# at the childe's death close all opened handlers
END {
    my ($key, $val);
    while(($key, $val) = each %ADM::Pfile::bundle){
        if(defined($val)) {
            close($val);
            ADM::Logs::DeBug("closing log entry $key")
                if($admin::Conf->GetVal('debug_level') > 2);
        } else {
            ADM::Logs::DeBug("bad entry in ADM::Pfile::bundle -> $key")
                if($admin::Conf->GetVal('debug_level') > 1);
        }
    }
}

1;
