# Interface for Template Toolkit package
#
# $Id: Template.pm,v 2.1 2006-06-06 13:38:57 shurukhin Exp $ $Name: not supported by cvs2svn $
#
package ADM::Template;
use strict;
use utf8;
use open qw(:std :utf8);

sub new($;$) {
    my ($proto, $tt) = @_;
    unless((defined $proto)) {
        return undef;
    }

    my $this = {};

    $this->{'__TT__'} = $tt || $main::Template;
    $this->{'__VARS__'} = {};
    $this->{'__TEMPLATE__'} = '';
    
    unless($this->{'__TT__'}) {
        return undef;
    }

    my $class = ref($proto) || $proto;
    bless($this, $class);
}

sub Assign($$$){
    my ($this, $name, $value) = @_;
    unless((defined $this) && (defined $name)){
        return undef;
    }
    
    my $type = ref $value;
    my $val = undef;
    if ($type && ($type eq 'SCALAR')){
        $val = $$value;
    } else{
        $val = $value;
    }
    
    $this->{'__VARS__'}->{$name} = $val;
}

sub SetTemplate($$){
    my ($this, $tfile) = @_;
    unless((defined $this) && (defined $tfile)){
        return undef;
    }
    $this->{'__TEMPLATE__'} = $tfile;
}

sub Parse($){
    my ($this) = @_;
    unless(defined $this){
        return undef;
    }
    my $output = '';
    $this->{'__TT__'}->process($this->{'__TEMPLATE__'}, $this->{'__VARS__'}, \$output) ||
        ADM::Logs::IntErr('[TT] ' .$this->{'__TT__'}->error());
    
    return $output;
}

sub Print($){
    my ($this) = @_;
    unless(defined $this){
        return undef;
    }
    $this->{'__TT__'}->process($this->{'__TEMPLATE__'}, $this->{'__VARS__'}) ||
        ADM::Logs::IntErr('[TT] ' .$this->{'__TT__'}->error());
    
    return 1;
}

sub PrintFile($$){
    my ($this, $handle) = @_;
    unless(defined $this){
        return undef;
    }
    $this->{'__TT__'}->process($this->{'__TEMPLATE__'}, $this->{'__VARS__'}, $handle) ||
        ADM::Logs::IntErr('[TT] ' .$this->{'__TT__'}->error());
    
    return 1;
}

sub Dispose($){
    my ($this) = @_;
    unless(defined $this){
        return undef;
    }
    
    undef $this->{'__TT__'};
    undef $this->{'__VARS__'};
    undef $this->{'__TEMPLATE__'};
    undef $this;
    
    return 1;
}

1;
