#!/bin/sh

PASSPDIR="/opt/www/adm.yandex.net"
TODAY=`date '+%Y%m%d'`
LOGSDIR="log"
LOGS="change.log event.log authnew.log"

cd $PASSPDIR

for logdir in $LOGSDIR; do
for log in $LOGS; do
TARGET_LOG="$logdir/$log"
SOURCE_LOG="$logdir/parse/$log.$TODAY"
[ ! -f $SOURCE_LOG ] && touch $SOURCE_LOG && chown www-data $SOURCE_LOG && chmod 0644 $SOURCE_LOG && echo $SOURCE_LOG created
[ ! -f $TARGET_LOG ] && [ -f $SOURCE_LOG ] && ln $SOURCE_LOG $TARGET_LOG && echo $SOURCE_LOG linked to $TARGET_LOG
done
done
