package AIO::Requester;

use strict;

use utf8;
use open qw(:std :utf8);

use Data::Dumper;
require LWP::UserAgent;
use IO::Socket::SSL;
use URI::Escape;
use JSON::XS;
use Encode qw{encode decode};
use Time::HiRes;
use Common::Puny 'email_to_puny';
use HTTP::Request;
use HTTP::Request::Common;
use URI;
use URI::QueryParam;
use Sub::Retry;
use Tie::IxHash;
use Carp;

# Creates object and returns blessed ref
sub new {
    my ($proto, $timeout)  = @_;

    my $ua = LWP::UserAgent->new();
    $ua->timeout($timeout || 7);
    $ua->ssl_opts(verify_hostname => SSL_VERIFY_PEER)
      if $ua->can('ssl_opts');
    my $class = ref $proto || $proto;

    my $self = bless({
        'UA'    => $ua,
        'ERROR' => ''
    }, $class);

    return $self;
}

sub ua {shift->{UA}}

=head2 _GetSocialUserProfiles(uid => $uid[, include => $include, expand => $expand])
Метод получения социальных профилей юзера по uid.
Возвращает ссылку на массив профилей.
Подробнее см http://wiki.yandex-team.ru/social/api#spisok
=cut
sub _GetSocialUserProfiles {
    my $self = shift;
    my %param = @_;

    die "uid is required"
      unless $param{uid};

    my $url = URI->new('http://' . $main::Conf->GetVal('social_api_host'));
    $url->path_segments('api', 'user', $param{uid}, 'profile');
    $url->query_param('include', $param{include}) if $param{include};
    $url->query_param('expand',  $param{expand})  if $param{expand};

    my $response = $self->ua->get($url);

    return []
      if $response->code == 404;

    die (
        "bad status of social response url=$url: (",
        $response->status_line, ") ", $response->content,
    ) unless $response->is_success;

    my $result = eval { decode_json $response->content };
    die "invalid json content of social response: $@"
      if $@;

    return $result->{profiles};
}

### BLACKBOX

sub _GetUsersInfo {
    my ($self, %args) = @_;

    my %query;
    tie %query, 'Tie::IxHash';

    $query{method} = 'userinfo';
    $query{format} = 'json';

    if ($args{uid}) {
        $query{uid} = $args{uid};
    }
    elsif ($args{login}) {
        $query{login} = $args{login};
        $query{sid}   = $args{sid} || 'passport';
    }
    elsif ($args{uids}) {
        $query{uid} = join ',', @{ $args{uids} };
    }
    elsif ($args{suid}) {
        $query{suid} = $args{suid};
        $query{sid}  = 2;
    }

    $query{userip} = $args{ip};

    %query = (%query, @{ $args{queries} })
      if $args{queries};

    my $url = URI->new($main::Conf->GetVal('blackbox_url'));
    $url->query_form(%query);

    my $decoded = eval { $self->_GetJsonFromUrl($url) };
    die "blackbox-userinfo: $@. url=$url"
      if $@;

    my $error  = $decoded->{error};
    my $result = $decoded->{users};

    $error = $decoded->{users}[-1]{error} || undef
      if not $error and $result and ref $result eq 'ARRAY' and @$result;

    die "blackbox-userinfo: error response. error=$error. url=$url"
      if $error;

    return $result;
}

sub _GetUserInfo {
    my ($self, %args) = @_;

    my $users = $self->_GetUsersInfo(%args);

    return unless @$users;
    return $users->[0];
}

sub _LoginOccupation {
    my ($self, %args) = @_;

    my %query;
    tie %query, 'Tie::IxHash';

    $query{method} = 'loginoccupation';
    $query{format} = 'json';

    $query{ignore_stoplist} = 1
      if $args{ignore_stoplist};

    $query{logins} = join ',', @{ $args{logins} };
    $query{is_pdd} = 1
      if $args{is_pdd};

    my $url = URI->new($main::Conf->GetVal('blackbox_url'));
    $url->query_form(%query);

    my $decoded = eval { $self->_GetJsonFromUrl($url) };
    die "blackbox-loginoccupation: $@. url=$url"
      if $@;

    my $error = $decoded->{error};
    die "blackbox-loginoccupation: error response. error=$error. url=$url"
      if $error;

    my $result = $decoded->{logins};
    die "blackbox-loginoccupation: no logins. url=$url"
      unless $result;

    return $result;
}

sub _CreateSessionId {
    my ($self, %args) = @_;

    my $sessionid = $args{sessionid};

    my %query;
    tie %query, 'Tie::IxHash';

    $query{method}         = 'createsession';
    $query{format}         = 'json';

    $query{ver}            = 3;

    $query{get_safe}       = 1
      if $args{get_safe};
    $query{host}           = $args{host};
    $query{userip}         = $sessionid->ip;
    $query{host_id}        = $args{passport_host};
    $query{keyspace}       = $sessionid->key_space_name
      if $sessionid->key_space_name;

    $query{uid}            = $sessionid->uid;
    $query{create_time}    = $sessionid->created;
    $query{auth_time}      = int($sessionid->started * 1000)
      if $sessionid->started;
    $query{ttl}            = $sessionid->policy_id;
    $query{delta}          = $sessionid->delta
      if $sessionid->delta;
    $query{have_password}  = $sessionid->user_have_password;
    $query{password_check_time} = $sessionid->password_verificated
      if $sessionid->password_verificated;
    $query{social_id}      = $sessionid->social_profile_id
      if $sessionid->social_profile_id;
    $query{authid}         = $sessionid->tag
      if $sessionid->tag;

    $query{is_stress}      = 1 if $sessionid->is_stressed;
    $query{is_lite}        = 1 if $sessionid->is_lite;
    $query{is_yastaff}     = 1 if $sessionid->is_yandexoid;
    $query{is_betatester}  = 1 if $sessionid->is_betatester;

    my $url = URI->new($main::Conf->GetVal('blackbox_url'));
    $url->query_form(%query);

    my $decoded = eval { $self->_GetJsonFromUrl($url) };
    die "blackbox-createsession: $@. url=$url"
      if $@;

    my $error = $decoded->{error};
    die "blackbox-createsession: error response. error=$error"
      if $error;

    my $result = $decoded;

    return $result;
}

sub _EditSessionId {
    my ($self, %args) = @_;

    my $sessionid = $args{sessionid};

    my %query;
    tie %query, 'Tie::IxHash';

    $query{method}         = 'editsession';
    $query{format}         = 'json';

    $query{op}             = $args{operation};

    $query{sessionid}      = $args{old_sessionid}->string;
    $query{sslsessionid}   = $args{old_sessionid}->sslstring
      if $args{old_sessionid}->sslstring;
    $query{host}           = $args{host};
    $query{userip}         = $args{ip};
    $query{uid}            = $args{uid};

    if ($args{operation} eq 'add') {
        $query{have_password}  = $sessionid->user_have_password;
        $query{password_check_time} = $sessionid->password_verificated
          if $sessionid->password_verificated;
        $query{social_id}      = $sessionid->social_profile_id
          if $sessionid->social_profile_id;

        $query{is_lite}        = 1 if $sessionid->is_lite;
        $query{is_yastaff}     = 1 if $sessionid->is_yandexoid;
        $query{is_betatester}  = 1 if $sessionid->is_betatester;
        $query{is_safe}        = 1 if $args{get_safe};

        $query{new_default}    = $args{uid};
    }

    my $url = URI->new($main::Conf->GetVal('blackbox_url'));
    $url->query_form(%query);

    my $decoded = eval { $self->_GetJsonFromUrl($url) };
    die "blackbox-editsession: $@. url=$url"
      if $@;

    my $error = $decoded->{error};
    die "blackbox-editsession: error response. error=$error"
      if $error;

    my $result = $decoded;

    return $result;
}

sub _CheckSessionId {
    my ($self, %args) = @_;

    my %query;
    tie %query, 'Tie::IxHash';

    $query{method}       = 'sessionid';
    $query{format}       = 'json';
    $query{authid}       = 'yes';
    $query{multisession} = 'yes';
    $query{host}         = $args{host};
    $query{sessionid}    = $args{sessionid};
    $query{sslsessionid} = $args{sslsessionid};
    $query{userip}       = $args{ip};

    %query = (%query, @{ $args{queries} });

    my $url = URI->new($main::Conf->GetVal('blackbox_url'));
    $url->query_form(%query);

    my $decoded = eval { $self->_GetJsonFromUrl($url) };
    die "blackbox-sessionid: $@. url=$url"
      if $@;

    my $error = $decoded->{error};
    die "blackbox-sessionid: error response. error=$error"
      unless $decoded->{status}{value};

    my $result = $decoded;

    return $result;
}

sub _GetMailHosts {
    my ($self, %args) = @_;

    my $url = $main::Conf->GetVal('blackbox_url');
    $url .= '?method=get_hosts';
    $url .= '&format=json';
    $url .= '&is_pdd=1' if $args{is_pdd};
    $url .= "&sid=$args{sid}" if $args{sid};

    my $decoded = eval { $self->_GetJsonFromUrl($url) };
    die "blackbox-gethosts: $@. url=$url"
      if $@;

    my $error = $decoded->{error};
    die "blackbox-gethosts: error response. error=$error"
      if $error;

    my $result = $decoded->{hosts} || [];

    return $result;
}

sub _GetHostedDomains {
    my ($self, %args) = @_;

    my %query;
    tie %query, 'Tie::IxHash';

    $query{method}  = 'hosted_domains';
    $query{format}  = 'json';
    $query{aliases} = 1;

    $query{domain_id}    = $args{domain_id}   if $args{domain_id};
    $query{domain}       = substr($args{domain_name}, 0, 300)
      if $args{domain_name};
    $query{domain_admin} = $args{admin_uid}   if $args{admin_uid};

    my $url = URI->new($main::Conf->GetVal('blackbox_url'));
    $url->query_form(%query);

    my $decoded = eval { $self->_GetJsonFromUrl($url) };
    die "blackbox-hosteddomains: $@. url=$url"
      if $@;

    my $error = $decoded->{error};
    die "blackbox-hosteddomains: error response. error=$error"
      if $error;

    my $result = $decoded->{hosted_domains} || [];

    return $result;
}

sub _FindPddAccounts {
    my ($self, %args) = @_;

    my %query;
    tie %query, 'Tie::IxHash';

    $query{method}  = 'find_pdd_accounts';
    $query{format}  = 'json';

    $query{domain_id}    = $args{domain_id}   if $args{domain_id};
    $query{domain}       = $args{domain_name} if $args{domain_name};
    $query{login}        = $args{login}       if $args{login};
    $query{limit}        = $args{limit}       if $args{limit};
    $query{offset}       = $args{offset}      if $args{offset};
    $query{sort}         = $args{sort}        if $args{sort};

    my $url = URI->new($main::Conf->GetVal('blackbox_url'));
    $url->query_form(%query);

    my $decoded = eval { $self->_GetJsonFromUrl($url) };
    die "blackbox-findpddaccounts: $@. url=$url"
      if $@;

    my $error = $decoded->{error};
    die "blackbox-findpddaccounts: error response. error=$error"
      if $error;

    my $result = $decoded;

    return $result;
}

### service

sub _GetThroughRetryer {
    my $sub_ref = shift;
    my $timeout = shift;
    my @params = @_;

    my (undef, undef, undef, $caller) = caller 1;
    my $requester = ref $params[0] eq 'AIO::Requester' ?  shift @params : AIO::Requester->new();
    $requester->{UA}->timeout($timeout);

    my $result;

    $result = eval { $sub_ref->($requester, @params) };

    return $result unless $@;

    Common::Logs::AdMin("http-request. attempt=1. exception=$@");
    Time::HiRes::sleep(0.3);

    $result = eval { $sub_ref->($requester, @params) };

    return $result unless $@;

    local $Data::Dumper::Indent = 0;

    my $longmess = Carp::longmess;
    Common::Logs::IntErr("http-request. attempt=2. exception=$@");

    die $@;
}

sub _GetContentFromUrl {
    my ($self, $url, $post, %headers) = @_;

    my $response
      = $post
      ? $self->{UA}->post($url, $post, %headers)
      : $self->{UA}->get($url, %headers);

    die "unsuccessful response. status=", $response->status_line, ". url=$url"
      unless $response->is_success;

    my $result = $response->content;

    die "empty response. url=$url"
      unless length $result;

    return \$result;
}

sub _GetJsonFromUrl {
    my $self = shift;

    my $encoded_ref = $self->_GetContentFromUrl(@_);
    my $decoded = eval { decode_json $$encoded_ref };

    die "invalid json response. exception=$@"
      if $@;

    return $decoded;
}

sub GetUsersInfo              { _GetThroughRetryer(\&_GetUsersInfo,          1, @_) }
sub GetUserInfo               { _GetThroughRetryer(\&_GetUserInfo,           1, @_) }
sub LoginOccupation           { _GetThroughRetryer(\&_LoginOccupation,       1, @_) }
sub CreateSessionId           { _GetThroughRetryer(\&_CreateSessionId,       1, @_) }
sub EditSessionId             { _GetThroughRetryer(\&_EditSessionId,         1, @_) }
sub CheckSessionId            { _GetThroughRetryer(\&_CheckSessionId,        1, @_) }
sub GetMailHosts              { _GetThroughRetryer(\&_GetMailHosts,          1, @_) }
sub GetHostedDomains          { _GetThroughRetryer(\&_GetHostedDomains,      1, @_) }
sub FindPddAccounts           { _GetThroughRetryer(\&_FindPddAccounts,       1, @_) }
sub GetSocialUserProfiles     { _GetThroughRetryer(\&_GetSocialUserProfiles, 1, @_) }

1;
