package Common::Csrf;

use strict;

use Digest::MD5 'md5_hex';

sub GenerateToken {
    my %args = @_;
    return unless scalar @{ $args{fields} };
    my $time = $args{time} || time;
    my $token = join '.', $time, md5_hex(join '.', @{ $args{fields} }, $time);
    return $token;
}

sub ValidateToken {
    my %args = @_;
    return unless my $token = $args{token};
    my ($time) = split /\./, $token, 2;
    return $token eq GenerateToken('time' => $time, fields => $args{fields});
}

sub GetTokenLifetime {
    return unless my $token = shift;
    my ($token_time) = split /\./, $token, 2;
    return unless $token_time =~ /^\d{10}$/;
    return time - $token_time;
}

1;

