package Common::Geobase;

use common::sense;

my %OLD_TO_NEW_CODE     = (
    ar => 'AM',
    be => 'BY',
    kr => 'KG',
    mo => 'MD',
    po => 'PL',
    tz => 'TJ',
    ge => 'DE',
    gg => 'GE',
    ch => 'CZ',
    sw => 'CH',
    lt => 'LV',
    lv => 'LT',

    na          => '',
    notselected => '',
);

sub NormalizeCountryCode {
    my $code = shift;

    return $code if $code =~ /^[A-Z]{2}$/;
    return $OLD_TO_NEW_CODE{$code} if exists $OLD_TO_NEW_CODE{$code};
    return uc $code;
}

1;
