# Package containing misc function
# which don't require some xternal functionality
#
# $Id: Misc.pm,v 2.2 2006-12-18 10:43:49 shurukhin Exp $ $Name: not supported by cvs2svn $
#
package Common::Misc;
use strict;
use utf8;
use open qw(:std :utf8);

sub IsIn($$) {
    my ($in, $elem) = @_;
    unless (defined($in) and ref($in) eq 'ARRAY' and defined($elem)) {
        return undef;
    }
    foreach (@{$in}) {
        if($_ eq $elem) {
            return 1;
        }
    }

    return 0;
}

# Weekdays for GetNow
my @Wdays = ('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
            'Friday', 'Saturday');
# Monthes for GetNow
my @Monthes = ('Jun', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
            'Aug', 'Sep', 'Oct', 'Nov', 'Dec');

# Returns current time formated in agreement with HTTP date/time
# representation standart
sub GetNow {
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday) = gmtime(time);
    my $now = sprintf("%s, %02d-%s-%02d %02d:%02d:%02d GMT",
                      $Wdays[$wday], $mday, $Monthes[$mon], $year-100,
                      $hour, $min, $sec);
    undef $sec;
    undef $min;
    undef $hour;
    undef $mday;
    undef $mon;
    undef $year;
    undef $wday;
    undef $yday;
    return $now;
}

# returns now string
sub Now {
    my ($sec,$min,$hour,$mday,$mon,$year,undef,undef) = localtime;
    my $now = sprintf("%4d-%02d-%02d %02d:%02d:%02d",
                      $year + 1900, $mon + 1, $mday, $hour, $min, $sec);
    undef $sec;
    undef $min;
    undef $hour;
    undef $mday;
    undef $mon;
    undef $year;
    return $now;
}

sub GetMethodRef {
    my ($self, $method) = @_;
    return sub { return $self->$method(@_) };
}

sub NumberAccusative($$$$){
    my ($number, $phrase1, $phrase2, $phrase5) = @_;
    
    unless(defined($number) && ($number =~ m,^[+\-]?\d$,) && defined($phrase1) && defined($phrase2) && defined($phrase5)){
        return undef;
    }
    $number =~ s,^[+\-],,;
    $number = $number % 100;
    if ($number >= 20){
        $number = $number % 10;
    }
    if ($number == 1){
        return $phrase1;
    } elsif (($number > 1) && ($number < 5)){
        return $phrase2;
    } else {
        return $phrase5;
    }
}

1; # Must return true
