package Common::Pfile;

use strict;
use utf8;

use Fcntl;
use Symbol;

use Global;

%Common::Pfile::bundle = ();

# function for opening persisten (through the childe's life) 
sub POpen {
    my ($fname) = @_;
    unless(defined($fname) and $fname) {
        return undef;
    }
    if(defined($Common::Pfile::bundle{$fname})) {
        if (-e $fname) {
            return $Common::Pfile::bundle{$fname};
        } else {
            PClose($fname);
        }
    }
    my $tmphandle = Symbol::gensym;
    my $res;
    if(-e $fname) {
        $res = sysopen($tmphandle, $fname, O_WRONLY|O_APPEND|O_NONBLOCK);
    } else {
        $res = sysopen($tmphandle, $fname, O_WRONLY|O_APPEND|O_CREAT|O_NONBLOCK);
    }
    if($res) {
        $Common::Pfile::bundle{$fname} = $tmphandle;
        return $tmphandle;
    } else {
        Common::Logs::DeBug("in POpen: can't open file $fname: $!")
            if($main::Conf->GetVal('debug_level'));
        return undef;
    }
}

sub PClose {
    my ($fname) = @_;
    unless (defined($fname) and ($fname)){
        Common::Logs::DeBug("in PClose: can't close file: called without filename");
        return undef;
    }
    if (defined($Common::Pfile::bundle{$fname})){
        my $rc = close $Common::Pfile::bundle{$fname};
        delete $Common::Pfile::bundle{$fname};
        unless ($rc){
            Common::Logs::DeBug("in PClose: can't close file $fname: $!");
            return undef;
        } else{
            return 1;
        }
    } else{
        return 0;
    }
}
    
sub PWrite {
    my ($fname, $string, $encoding_preset) = @_;
    unless(defined($fname) and defined($string)){
        Common::Logs::DeBug("In DoLog: bad parameters")
            if($main::Conf->GetVal('debug_level'));
        return undef;
    }
    my $handle = POpen($fname);
    unless(defined($handle)){
        return undef;
    }
    #Common::Logs::DeBug(' Call  PWrite ');
    #Common::Logs::Caller;
    $encoding_preset ||= 'log';
    Global::EncodeAll($string, 'inner', $encoding_preset);
    unless(syswrite($handle, $string, length($string))) {
        Common::Logs::DeBug("In DoLog: error writing log: $!")
            if($main::Conf->GetVal('debug_level'));
        return undef;
    }
    return 1;
}

# at the childe's death close all opened handlers
END {
    my ($key, $val);
    while(($key, $val) = each %Common::Pfile::bundle){
        if(defined($val)) {
            close($val);
            Common::Logs::DeBug("closing log entry $key")
                if($main::Conf->GetVal('debug_level') > 2);
        } else {
            Common::Logs::DeBug("bad entry in Common::Pfile::bundle -> $key")
                if($main::Conf->GetVal('debug_level') > 1);
        }
    }
}

1;
