package DBAF;

use vars qw(@ISA);

use DBAF::Safe;
use DBAF::SafeForDomains;
push (@ISA, qw(DBAF::Safe DBAF::SafeForDomains));
use strict;
use utf8;
use open qw(:std :utf8);

use Class::XSAccessor {
    accessors => [qw/uid_collection central_group/],
};

my $singleton = undef;
sub instance      { $singleton         }
sub SkipSingleton { $singleton = undef }

sub NewDBAF {
    my $proto = shift;
    unless(defined($proto)) {
        return undef;
    }
    my $class = ref($proto) || $proto;
    my $self = {};
    bless($self, $class);
    $self->{'SAFE'} = 0;
    $self->{'SAFEFORDOMAINS'} = 0;
    $singleton = $self; 
    return $self;
}

sub NewSAFE {
    my $self = shift;
    unless(defined($self)) {
        return undef;
    }
    my $sfg = DBAF::Safe->new($self);
    unless(defined($sfg)) {
        return undef;
    }
    $self->{'SAFE'} = $sfg;
    return $sfg;
}

sub NewSAFEFORDOMAINS {
    my $self = shift;
    unless(defined($self)) {
        return undef;
    }
    my $sfg = DBAF::SafeForDomains->new($self);
    unless(defined($sfg)) {
        return undef;
    }
    $self->{'SAFEFORDOMAINS'} = $sfg;
    return $sfg;
}

sub IsAlive ($) {
    my $this = shift;
    
    unless(defined($this)){
        $this->{'ERROR'} = 'Internal';
        return undef;
    }
    
    $this->{'ERROR'} = '';
    
    unless(defined($this->{'SAFE'})) {
        $this->{'ERROR'} = 'Subclass arent initialized';
        return undef;
    }
    
    return 1;
}

1;
