package Database::Collection;

use common::sense;

use Log::Any '$log';

use Class::XSAccessor {
    constructor => 'new',
    accessors   => [qw/name shard_id_chooser group_chooser groups/],
};

sub get_shard_id_by_key {
    my $self = shift;
    my ($key) = @_;

    my $shard_id = $self->shard_id_chooser->($key);

    die "unknown shard for key $key"
      unless defined $shard_id;

#    $log->debugf('collection=%s key=%s shard_id=%d', $self->name, $key, $shard_id);

    return $shard_id;
}

sub get_group_by_shard_id {
    my $self = shift;
    my ($shard_id) = @_;

    my $group = $self->group_chooser->($shard_id);

    die "unknown group for shard $shard_id"
      unless $group;

#    $log->debugf('collection=%s shard_id=%d group=%s', $self->name, $shard_id, $group->name);

    return $group;
}

sub get_group_by_key {
    my $self = shift;
    my ($key) = @_;

    my $shard_id = $self->get_shard_id_by_key($key);
    my $group    = $self->get_group_by_shard_id($shard_id);

    return $group;
}

sub get_master_by_key { shift->get_group_by_key(@_)->master }
sub get_slave_by_key  { shift->get_group_by_key(@_)->slave  }

sub masters { [ map { $_->master } @{ shift->groups } ] }
sub slaves  { [ map { $_->slave  } @{ shift->groups } ] }

1;
