package Database::Connection;

use common::sense;

use DBI;

use Class::XSAccessor {
    constructor => 'new',
    accessors   => [qw/dsn host port name user pass connect_timeout group_name/],
};

sub connect {
    my $self = shift;

    my $dsn = $self->get_dsn;

    my $args = {
        RaiseError => 1,
        PrintError => 0,
    };

    my $dbh = DBI->connect($dsn, $self->user, $self->pass, $args);
    $dbh->{mysql_auto_reconnect} = 1;
    #$dbh->{mysql_enable_utf8} = 1;
    #$dbh->do('SET NAMES utf8');
    $dbh->do('SET NAMES binary');

    $self->{dbh} = $dbh;

    return $dbh;
}

sub get_dsn {
    my $self = shift;

    die "connection properties are required"
      unless ($self->dsn or ($self->host and $self->name)) and $self->user and $self->pass;

    my $result
      =  $self->dsn
      || sprintf(
        'dbi:mysql:hostname=%s;port=%d;database=%s;mysql_connect_timeout=%d',
         $self->host, $self->port || 3306, $self->name, $self->connect_timeout || 1,
      );

    return $result;
}

sub dbh {
    my $self = shift;

    return $self->{dbh} || $self->connect;
}

sub execute {
    my $self = shift;
    my ($query, @values) = @_;

    my $dbh = $self->dbh;
    my $sth = $dbh->prepare($query);
    $sth->execute(@values);

    return $sth;
}

sub do {
    my $self = shift;
    my ($query, @values) = @_;

    my $dbh = $self->dbh;
    my $result = $dbh->do($query, undef, @values);

    return $result;
}

1;
