package Global;

use strict;
use utf8;
use open qw(:std :utf8);
use warnings;
use URI::Escape;
use Time::Local;
use POSIX 'ceil';

#after entering mail on domain we have at last two independed modes
#all finction wich concern modes 

our $BrowserDetector;
our $I18n;
our $AvailableLanguages;

sub DMDomain {  
    $Input::dm_domain = $_[0] if defined $_[0];
    return $Input::dm_domain;
}

#
# It's hack for migration time
#
our $standart_preset = {
#    input       => [ qw/utf8 cp1251/    ],
#    output      => [ qw/utf8/         ],
#    #db          => [ qw/cp1251 utf8/    ], #auto 
#    db          => [ qw/cp1251 utf8/    ], #auto 
#    inner       => [ qw/utf8/         ],
};
our $md_preset = {    
#    input       => [ qw/utf8 cp1251/    ], #auto
#    output      => [ qw/utf8/         ],
#    db          => [ qw/utf8 cp1251/    ], #auto 
#    inner       => [ qw/utf8/         ],
};
sub DMMode {
    if(defined $_[0]){
        $Input::dm_mode = $_[0];
        #TODO REMOVE THIS BADD HACK AFTER MIGRATION
        if($_[0]){
            Encoding( %$md_preset );
        } else {
            Encoding( %$standart_preset );     
        }
    }
    return $Input::dm_mode;
}

sub YTMode   { $main::Conf->GetVal('yandexteam') ? 1 : 0 }
sub IsPddUid { shift >= 1130000000000000 }

sub GetBasePassportUrl {
    my $host   = $main::Conf->GetVal('pass_domain');

    my $result = "https://$host";

    if (DMMode()) {
        my $root = $main::Conf->GetHCVal('DomainMailRootDir');
        $result .= "/$root/";
        $result .= uri_escape_utf8( DMDomain() )
          if DMDomain();
    }

    return $result;
}

sub GetPassURL {
    if(DMMode()){
        my $root = $main::Conf->GetHCVal('DomainMailRootDir');

        my $url = 'https://'.
        $main::Conf->GetVal('pass_domain')."/". $root ."/";
        if( DMDomain() ){
            $url .= uri_escape_utf8( DMDomain() ) .'/';                    
        }
        return $url;
    } else {
        return $main::Conf->GetVal('pass_https');
    }
}

sub GetMdaURL { $main::Conf->GetVal('pass_pass_https') }

sub GetCookiePath { '/' }


# Encoding zone 
# templraly placed here

# we need to re init this zone each time
#

my $encoding = {
    input       => [ qw/utf8/    ],
    output      => [ qw/utf8/         ],
    db          => [ qw/utf8/    ], #auto 
    #db          => [ qw/cp1251/    ], #auto
    dbutf8cp1251=> [ qw/utf8 cp1251/ ], 
    dbcp1251    => [ qw/cp1251/    ], #auto
#   dbcp1251    => [ qw/cp1251 utf8/    ], #auto
    dbutf8      => [ qw/utf8/    ], #auto
    inner       => [ qw/utf8/         ],
    uriutf8     => [ qw/utf-8/          ],
    uricp1251   => [ qw/cp1251/         ],
    'log'       => [ qw/cp1251/         ], 
    inner_flag  => 1,
};

#TODO REMOVE this function NAHREN
sub Encoding {
    my %attr = @_;
#   return 0;
#   Common::Logs::DeBug('Cange Encoding' . join(', ', %attr));
#   Common::Logs::Caller();
    #for my $name (qw/input output db inner xml/){}
    for my $name ( keys %attr ){
        if($attr{$name}){
            if      (ref($attr{$name}) eq ''){
                $encoding->{$name} = [$attr{$name}];
            }
            elsif   (ref($attr{$name}) eq 'ARRAY'){
                $encoding->{$name} = $attr{$name};
            }
            else {
                Common::Log::DeBug('Uncommon reference '.$attr{$name}." come to Encoding");
            }
            if($name eq 'inner'){
                $encoding->{inner_flag} = ($encoding->{inner}->[0] =~/utf\-?8/o ? 1 : 0);
            }
        }
    }
}

#temporaly place encode fuction here
use Encode;
#use Data::Alias;
=head Encoding
 Encoding( name => encoding, name2 => [encodingA, encodingB], ...);
 
 bind alias for several encodings, used in Encode

=head Encode
 Encode( $val, from, to);

 from and to are name of data source / data writer
 Standart data sources
    input 
    output
    db
    inner (utf8 understands as UTF-X)
 
 if 'form' alises to several encodings - auto decde will be used
 for 'to' alias we will use the first one
 
=cut
sub Encode($$$);
sub EncodeAll($$$);


sub Encode($$$){
    my $val = $_[0];
    return unless $val; 
    #return if not ( $val=~/[^\x00-\x7F]/o );

    my ($from, $to) = @_[1, 2];

    #can die?

    my $to_encoding = $encoding->{$to}->[0];
    if( $from eq 'inner' and $encoding->{inner_flag} ){
        #from iner to any
        eval {
            $val = Encode::encode( $to_encoding, $val, Encode::LEAVE_SRC );
        };
        if ($@) {
            Common::Logs::IntErr('Encode FAIL: ' . $@);
        }
    }
    else {
        #from not inner to any
        if( scalar @{$encoding->{$from}} > 1 ){
            #auto decoding
            my $text = $val;
            my $res;
            $res = utf8::decode($text); #can die
            if( $res ){
                $val = $text;
            } 
            else {
                eval{
                    $val = Encode::decode('cp1251', $val, Encode::LEAVE_SRC );
                };
                if ($@) {
                    Common::Logs::IntErr('Encode FAIL: ' . $@);
                }
            }
            #$val now in inner encoding
        }
        else {
            eval {
                $val = Encode::decode( $encoding->{$from}->[0], $val, Encode::LEAVE_SRC );
            };
            if ($@) {
                Common::Logs::IntErr("Encode ($val) FIIL: " . $@);
                Common::Logs::Caller();
            }
        }

        if( not( $to eq 'inner' and $encoding->{inner_flag} )  ){
            eval {
                $val = Encode::encode( $to_encoding, $val, Encode::LEAVE_SRC );
            };
            if ($@) {
                Common::Logs::IntErr('Encode FAIL: ' . $@);
            }
        }
    }
    $_[0] = $val;
}
sub EncodeAll($$$) {
    my $ref = ref($_[0]);
    #print "ENCall: $ref\n";
    #warning deep in recursion
    if($ref eq ''){
        Encode($_[0], $_[1], $_[2] );
    }
    elsif($ref eq 'HASH'){
        foreach my $k ( keys %{$_[0]} ){
            EncodeAll($_[0]->{$k}, $_[1], $_[2]);
        } 
    }
    elsif($ref eq 'ARRAY'){
        for (my $i=0; $i< @{$_[0]}; $i++ ){
            EncodeAll($_[0]->[$i], $_[1], $_[2]);
        }
    }
}

sub BinarySearch {
    my ($target, $array) = @_;

    my ($low, $high) = (0, scalar @$array - 1);

    return $high
      if $target >= $array->[$high];

    return
      if $target < $array->[$low];

    while ($low < $high) {
        my $cur = int(($low + $high) / 2);
        if ($target >= $array->[$cur]) {
            if ($target < $array->[$cur + 1]) {
                return $cur;        # попали в нужный интервал
            }
            else {
                $low = $cur + 1;    # низковато ткнули, надо посмотреть повыше
            }
        }
        else {
            $high = $cur;           # высоковато ткнули, надо посмотреть пониже
        }
    }

    return $low;
}

sub DatetimeToTimestamp {
    my $datetime = shift;

    my ($year, $mon, $day, $hour, $min, $sec) = split /[-:\sT]+/, $datetime;

    return 0 unless $year and $mon and $day;
    return 0 if $year =~ /^0+$/;
    return 0 if $mon  =~ /^0+$/;
    return 0 if $day  =~ /^0+$/;

    my $result = timelocal($sec, $min, $hour, $day, $mon - 1, $year);

    return $result;
}

sub TimestampToLocalDatetime {
    my $ts = shift;

    my ($sec, $min, $hour, $day, $mon, $year) = localtime $ts;
    my $result = sprintf '%04d-%02d-%02d %02d:%02d:%02d', $year + 1900, $mon + 1, $day, $hour, $min, $sec;

    return $result;
}

sub TimestampToUtcDatetime {
    my $ts = shift;

    my ($sec, $min, $hour, $day, $mon, $year) = gmtime $ts;
    my $result = sprintf '%04d-%02d-%02d %02d:%02d:%02d', $year + 1900, $mon + 1, $day, $hour, $min, $sec;

    return $result;
}

sub TimestampToLocalDate {
    my $ts = shift;

    my (undef, undef, undef,, $day, $mon, $year) = localtime $ts;
    my $result = sprintf '%04d-%02d-%02d', $year + 1900, $mon + 1, $day;

    return $result;
}

return 1;
