package I18n;

use common::sense;

use File::Slurp;
use File::Spec::Functions;
use Hash::Merge 'merge';
use JSON;
use List::MoreUtils 'uniq';
use Readonly;

Readonly my $ONE  => 0;
Readonly my $SOME => 1;
Readonly my $MANY => 2;

sub new { bless {}, shift }

sub load_dir {
    my $self = shift;
    my ($dirpath) = @_;

    opendir my $dir, $dirpath
      or die "can't open dir '$dirpath': $!";

    my @names = grep { /\.json$/ } readdir $dir;

    closedir $dir;

    for my $name (@names) {
        my $path = catfile($dirpath, $name);
        $self->load_file($path);
    }

    return;
}

sub load_file {
    my $self = shift;
    my ($path) = @_;

    my $json = read_file($path);

    my $db = eval { decode_json $json };

    die "can't decode json file '$path': $@"
      if $@;

    $self->merge_db($db->{_meta}{lang} => $db->{items});

    return;
}

sub merge_db {
    my $self = shift;
    my ($lang, $right) = @_;

    my $left = $self->{db}{$lang} || {};
    my $new  = merge $left, $right;

    $self->{db}{$lang} = $new;

    return;
}

sub langs {
    my $self = shift;

    my @result = sort keys %{ $self->{db} };

    return @result;
}

my $PLURAL_THREE_FORMS = sub {
    my ($count, $values) = @_;
    $count %= 100;
    $count %= 10 if $count % 100 >= 20;
    return $values->[$ONE]  if $count == 1;
    return $values->[$SOME] if $count > 1 and $count < 5;
    return $values->[$MANY];
};
my $PLURAL_TWO_FORMS = sub {
    my ($count, $values) = @_;
    return $values->[$ONE]  if $count == 1;
    return $values->[$SOME];
};
my %PLURAL = (
    ru => $PLURAL_THREE_FORMS,
    uk => $PLURAL_THREE_FORMS,
    tr => $PLURAL_TWO_FORMS,
    en => $PLURAL_TWO_FORMS,
);

sub l10n {
    my $self = shift;

    my ($lang, $key, $args) = @_;

    my $value = $self->{db}{$lang}{$key} || '';

    return $value unless %$args;

    if (my $count = $args->{count}) {
        return $PLURAL{$lang}->($count, $value);
    }

    return $value;
}

1;
