package IP;

use common::sense;

use Regexp::Common 'net';
use Regexp::IPv6 '$IPv6_re';

use Class::XSAccessor {
    accessors => [qw/is_v4 is_v6 is_mapped is_valid as_v4 as_v6/],
};

use overload (
    '""' => sub { shift->as_string },
    fallback => 1,
);

our $V4_NULL       = '0.0.0.0';
our $V6_NULL       = '::';
our $V4_RE         = qr/$RE{net}{IPv4}/;
our $V6_RE         = qr/$IPv6_re/;
our $V46_RE        = qr/$V4_RE|$V6_RE/;
our $MAPPED_PREFIX = '::ffff:';

sub new {
    my $class = shift;
    my $self = bless {}, $class;

    $self->init(@_);

    return $self;
}

sub init {
    my $self = shift;
    my $string = shift;

    if ($self->is_v4_string($string)) {
        $self->is_valid(1);
        $self->is_v4(1);
        $self->is_v6(0);
        $self->is_mapped(0);
        $self->as_v4($string);
        $self->as_v6($self->v4_to_v6($string));
    }
    elsif ($self->is_mapped_string($string)) {
        $self->is_valid(1);
        $self->is_v4(1);
        $self->is_v6(0);
        $self->is_mapped(1);
        $self->as_v4($self->v6_to_v4($string));
        $self->as_v6($string);
    }
    elsif ($self->is_v6_string($string)) {
        $self->is_valid(1);
        $self->is_v4(0);
        $self->is_v6(1);
        $self->is_mapped(0);
        $self->as_v4('');
        $self->as_v6($string);
    }
    else {
        $self->is_valid(0);
        $self->is_v4(0);
        $self->is_v6(0);
        $self->is_mapped(0);
        $self->as_v4('');
        $self->as_v6('');
    }

    return $self;
}

sub as_string {
    my $self = shift;

    my $result = $self->is_v6 ? $self->as_v6 : $self->as_v4;

    return $result;
}

sub is_v4_or_v6_string { $_[1] =~ /^                $V46_RE   $/ox  ? 1 : 0 }
sub is_v4_string       { $_[1] =~ /^                 $V4_RE   $/ox  ? 1 : 0 }
sub is_v6_string       { $_[1] =~ /^                 $V6_RE   $/ox  ? 1 : 0 }
sub is_mapped_string   { $_[1] =~ /^ $MAPPED_PREFIX  $V4_RE   $/iox ? 1 : 0 }
sub v6_to_v4           { $_[1] =~ /^ $MAPPED_PREFIX ($V4_RE)  $/iox; $1     }
sub v4_to_v6           { $MAPPED_PREFIX . $_[1] }

1;
