package Input;

use strict;
use utf8;
use open qw(:std :utf8);

use vars qw/
    $AllVals $Body $Cookie $from $fromdata $Input $io $Query $retpath $original_retpath $kspace
    $secure_mode $Requester $InCookies $dm_mode $dm_domain $authz
    $display $device $cookie_my $yandex_domain
/;

use URI::Escape;
use Encode;

use Authorization;

# these are module variables
my $state = 'auth';

=head1 FUTURE

Заделка под будущий рефакториг, когда будем съезжать с глобов.
Все обращения к глобам, отимально сначала перерисовать на ООП, поэтому пока делаю такю заглушку:
    
    use Input;
    my $in = Input->instance();
    $in->глоб;
    
=head2 instance

Абсолютно фековый интсанс, трубется пока для того чтобы скрыть обращение к глобам из кода.

=cut
sub instance {$_[0]}

=head2 from

Возвращает текущий from запроса.
Использовать только после вызова Input::GetFrom() в основном хэндлере

=cut
sub from {$Input::from}

=head2 secure_mode

Возвращает secure_mode (стутс http или https - булево)

=cut
sub secure_mode {$Input::secure_mode ? 1 : 0}

=head2 req

Возврщает объект AIO::Request

=cut
sub req {$Input::Input}



# a constructor of the passport input
#   requires request

sub InitInput($) {
    my $req = shift;

    $secure_mode = $ENV{"HTTPS"} eq 'on';

    # process input
    # collect all vars via IO
    $io = AIO->NewIO($req);
    unless($io) {
        Output::Complain('iobad', 'Bad I/O request!');
        return;
    }
    $Input = $io->NewRequest({DoCookies => 0, DoQuery => 0, DoBody => 0});
    unless($Input) {
        Output::Complain('iobad', 'NewRequest failed!');
        return;
    }
    $Requester = $io->NewRequester;
    unless($Requester) {
        Output::Complain('iobad', 'Newequester failes!');
        return;
    }
    my $error;
    
    $Cookie = $Input->DoCookies();
    
    # теперь в куке может быть не англ значение и нужно маркировать строку, как utf-8
    if ($Cookie->{yandex_login}) {
        Encode::_utf8_on($Cookie->{yandex_login});
    }    
    
    $InCookies = $Cookie;

    $Query = $Input->DoQuery();

    $Body = $Input->DoBody();
    unless($Body) {
        # check if error was fatal
        $error = $Input->GetError();
        if($error eq 'EIO') {
            Output::Complain('badrequest', 'Fatal body reading error!');
            return;
        }
    }
    $AllVals = $Input->JoinAllVars;

    if ($main::Conf->GetVal('debug_level')) {
        my $dump_parameters = '';
        if (defined $Input::Input->{'ip_from'}) {
            $dump_parameters .= "ip_from = '".$Input::Input->{'ip_from'}."' ";
        }
        if (defined $Input::Input->{'ip_prox'}) {
            $dump_parameters .= "ip_prox = '".$Input::Input->{'ip_prox'}."' ";
        }

        if (defined $AllVals->{'mode'}) {
            $dump_parameters .= "mode = '".$AllVals->{'mode'}."' ";
        }
        $dump_parameters .= join(',',keys(%$AllVals));
        Common::Logs::DeBug("[INCOME PARAMS] $dump_parameters");
    }

# Global variables initialization
    $from = undef;
    $fromdata = undef;
    $retpath = undef;
    $original_retpath = undef;
    $authz = Authorization->new;
    


# MailForDomain Handling
    $dm_mode     = 0; 
    $dm_domain   = '';
#    Common::Logs::DeBug('==Testing: '.$main::ENV{REQUEST_URI});
    my $root = $main::Conf->GetHCVal('DomainMailRootDir');

    if($main::ENV{REQUEST_URI}=~/^\/$root(\/([\%a-zA-Z_\w\d\-\.]+))?/o){
        #Domain mail mode is ON!
        Global::DMMode(1);
        Global::DMDomain( decode( 'utf8', uri_unescape( $2 )) ) if $2;
#        Common::Logs::DeBug("Incoming URL: $main::ENV{REQUEST_URI}, Domain: $2");
    } else {
        Global::DMMode(0);
    }

    return 1;
}

# Gets current state ('mode') of passport work
# requires no parameters at all
sub GetCurrentState() {
    my $modeset = $main::Conf->GetHCVal($dm_mode ? 'MdModeset' : 'Modeset');
    if( defined($AllVals->{'mode'}) and
        defined($modeset->{$AllVals->{'mode'}}) and
        $modeset->{$AllVals->{'mode'}} 
    ) 
    {
        $state = $AllVals->{'mode'} = lc $AllVals->{'mode'};
    } else {
        $state = 'passport';
    }
    return $state;
}

=head2 GetFrom()

Метод, инициализирует $Input::from и $Input::fromdata
Фактически получаем источник, обратившийся к пасспорту.

Возвращает $Input::from.

=cut
sub GetFrom {
    ($from, $fromdata) = undef;
    
    # определим from
    if ($AllVals->{from}) {
        $AllVals->{from}=~ s/[^a-zA-Z0-9]//g;
        $from           = $AllVals->{from};
        $fromdata       = $AllVals->{fromdata};
    } elsif ($retpath) {
        # если у нас обознчен retpath, и под него есть кастомизация,
        # то запомним соотвествующий from
        my $mimicry_conf = $Conf::HardCoded{mimicry};
        foreach my $mimicry_desc (values %$mimicry_conf) {
            my $retpath_re = $mimicry_desc->{retpath_re};
            next unless ref $retpath_re eq 'Regexp';
            if ($retpath =~ $retpath_re) {
                $from = $mimicry_desc->{from};
                last;
            }
        }
    }
    
    # запомним from в параметрах для шаблона
    if ($from) {
        $Output::formargs ->{from} = $from;
    }
    
    # *msg используется только для почты на этапе регистрации
    $AllVals->{msg} =~ s/[^a-zA-Z0-9]//g if exists $AllVals->{msg};

    return $from;
}

1;
