package LogAnyAdapter;

use common::sense;

use List::MoreUtils 'uniq';
use Log::Any::Adapter::Util 'make_method';

use Common::Logs;

use base 'Log::Any::Adapter::Base';

my %pairs = (
    DeBug  => [qw/debug info inform/],
    AdMin  => [qw/notice warn warning/],
    IntErr => [qw/err error fatal crit critical alert emergency/],
);

while (my ($function, $methods) = each %pairs) {
    my $code = <<EOC;
sub {
    shift;
    \@_ = (join '', \@_);
    local \$Common::Logs::caller_depth
        = \$Common::Logs::caller_depth + 1;
    \&Common:\:Logs:\:$function;
}
EOC
    my $sub = eval $code;
    die "can't create sub for function '$function' by template - $@"
      if $@;

    make_method($_, $sub)
      for @$methods;
}

make_method($_, sub { 1 })
  for Log::Any->detection_methods;

my @methods = map { $_ . 'f' } uniq(Log::Any->logging_methods, Log::Any->log_level_aliases);

for my $method (@methods) {
    my $code = <<EOC;
sub {
    my \$self = shift;
    local \$Common::Logs::caller_depth
        = \$Common::Logs::caller_depth + 2;
    \$self->SUPER:\:$method(\@_);
}
EOC
    my $sub = eval $code;
    die "can't create sub for method '$method' by template - $@"
      if $@;

    make_method($method, $sub);
}

1;
