package Model::Account;

use common::sense;

use Class::XSAccessor {
    constructor => 'new',
    accessors   => [qw/
        uid is_enabled registration_datetime registration_ts lite_login global_logout_datetime global_logout_datetime_local
        short_phone_number is_betatester yandexoid_login is_vip is_shared have_plus can_manage_children
        is_pdd_agreement_accepted disabling_reason family_info
        login karma domain person display_name subscriptions password aliases messages
        restoration hint emails phones social_profiles
        blackbox_response dbaf
    /],
};

use overload '""' => sub { shift->stringify }, fallback => 1;

sub stringify { shift->uid || '' }

sub is_pdd { shift->domain->id ? 1 : 0 }

sub is_lite {
    my $self = shift;

    return 0 if $self->is_pdd;
    return 1 if $self->login->internal =~ /\@/;
    return 0;
}

sub human_readable_login {
    my $self = shift;

    my $result
      = $self->is_pdd
      ? join('@', $self->login->internal, $self->domain->unicoded)
      : $self->login->user_defined;

    return $result;
}

sub human_readable_login_for_mode_passport {
    my $self = shift;

    my $result;

    if ($self->is_pdd) {
        $result = join('@', $self->login->internal, $self->domain->unicoded);
    }
    else {
        my $internal     = $self->login->internal;
        my $user_defined = $self->login->user_defined;

        my $normalized_internal     = lc $internal;
        my $normalized_user_defined = lc $user_defined;

        $normalized_user_defined =~ tr/./-/
          unless $normalized_user_defined =~ /\@/;

        if (not $normalized_internal eq $user_defined and $normalized_internal eq $normalized_user_defined) {
            $result = $user_defined;
        }
        else {
            $result = $internal;
        }
    }

    return $result;
}

sub machine_readable_login {
    my $self = shift;

    my $result
      = $self->is_pdd
      ? join('@', $self->login->internal, $self->domain->punycoded)
      : $self->login->internal;

    return $result;
}

sub is_yandexoid { shift->yandexoid_login ? 1 : 0 }

sub is_full_pdd {
    my $self = shift;

    return 1 unless $self->is_pdd;
    return 0 unless $self->is_pdd_agreement_accepted;
    return 0 unless $self->person->name;
    return 0 unless $self->hint->is_specified;
    return 1;
}

sub is_enabled_pdd {
    my $self = shift;

    return 0 unless $self->is_enabled;
    return 0 unless $self->domain->is_enabled;
    return 1;
}

sub have_messages {
    my $self = shift;

    my $messages = $self->messages;

    return ($messages && @$messages) ? 1 : 0;
}

sub have_password {
    my $self = shift;

    return $self->dbaf->UidHavePassword($self->uid);
}

sub have_login {
    my $self = shift;

    my $login = $self->login;

    return 0 if $login->is_social;
    return 0 if $login->is_phonish;
    return 1;
}

sub default_native_domain {
    my $self = shift;

    my $default_native_email = $self->emails->default_native;

    return unless $default_native_email;

    my ($username, $domain) = split /\@/, $default_native_email;

    return $domain;
}

1;
