package Model::Answer;

use common::sense;

use Class::XSAccessor {
    accessors => [qw/encrypted/],
};

sub new {
    my $class = shift;
    my (%args) = @_;

    my $self = bless {}, $class;

    $self->text($args{text});
    $self->encrypted($args{encrypted} || '');

    return $self;
}

sub text {
    my $self = shift;

    return $self->{text}
      unless @_;

    my $value = shift;
    $value = ''
      unless length $value;

    $self->{text} = $value;
    $self->normalized($value);

    return $self;
}

sub normalized {
    my $self = shift;

    return $self->{normalized}
      unless @_;

    my $value = shift;
    $value =~ s/^\s+//;
    $value =~ s/\s+$//;
    $value =~ s/\s+/ /g;
    $value = lc $value;

    $self->{normalized} = $value;

    return $self;
}

sub is_specified { length shift->normalized ? 1 : 0 }

sub is_equal {
    my $self = shift;
    my ($testing) = @_;

    my $result = $self->normalized eq $testing->normalized ? 1 : 0;

    return $result;
}

1;
