package Model::DisplayName;

use common::sense;

use Class::XSAccessor {
    constructor => 'new',
    accessors   => [qw/id prefix value profile_id provider_code/],
};

use overload 'cmp' => sub { shift->serialized cmp shift->serialized }, fallback => 1;
use overload 'eq'  => sub { shift->serialized eq  shift->serialized }, fallback => 1;

sub is_social             { shift->prefix eq 's'    ? 1 : 0 }
sub is_passport           { shift->prefix eq 'p'    ? 1 : 0 }
sub is_phone_number_alias { shift->prefix eq 'pna'  ? 1 : 0 }
sub is_freeform           { shift->id     eq 'p.ff' ? 1 : 0 }

sub serialized_as_passport {
    my $self = shift;
    
    return '' unless length $self->value;
    return 'p:' . $self->value;
}

sub serialized {
    my $self = shift;

    if ($self->is_passport or $self->is_phone_number_alias) {
        return '' unless length $self->value;
        return sprintf '%s:%s', $self->prefix, $self->value;
    }
    elsif ($self->is_social) {
        return '' unless $self->profile_id and $self->provider_code and $self->value;
        return sprintf '%s:%s:%s:%s', $self->prefix, $self->profile_id, $self->provider_code, $self->value;
    }
}

sub deserialize {
    my $self = shift;
    my ($string) = @_;

    if ($string =~ /^ (p|pna): (.*) $/x) {
        $self->prefix($1);
        $self->value($2);
    }
    elsif ($string =~ /^ (s): (\d+?) : ([a-z]{2}) : (.*) $/x) {
        $self->prefix($1);
        $self->profile_id($2);
        $self->provider_code($3);
        $self->value($4);
    }

    return;
}

1;
